/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;

public enum CommandWord {
    GO("go"),
    QUIT("quit"),
    HELP("help"),
    UNKNOWN("?"),
    BACK("back"),
    INSPECT("inspect"),
    TAKE("take"),
    DROP("drop"),
    EAT("eat"),
    USE("use"),
    ITEMS("items"),
    RESTART("restart"),
    FOLLOW("follow"),
    TALK("talk"),
    LOOK("look");

    private String commandString;
    private static HashMap<String, CommandWord> validCommands;

    private CommandWord(String commandString) {
        this.commandString = commandString;
    }

    public String toString() {
        return this.commandString;
    }

    public static CommandWord getCommandWord(String commandWord) {
        CommandWord command = validCommands.get(commandWord);
        if (command != null) {
            return command;
        }
        return UNKNOWN;
    }

    public static String getAllCommandWords() {
        StringBuilder sb = new StringBuilder("");
        for (String command : validCommands.keySet()) {
            sb.append(command + "  ");
        }
        return sb.toString();
    }

    public boolean isCommand(String aString) {
        return validCommands.containsKey(aString);
    }

    static {
        validCommands = new HashMap();
        for (CommandWord command : CommandWord.values()) {
            if (command == UNKNOWN) continue;
            validCommands.put(command.toString(), command);
        }
    }
}

