/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GameGUI
extends JPanel
implements ActionListener {
    private JTextField input;
    private JButton theButton;
    private JTextArea output;
    private GameModel gameModel = new GameModel();

    public GameGUI() {
        this.input = new JTextField(30);
        this.input.addActionListener(this);
        this.output = new JTextArea(10, 10);
        this.output.setEditable(false);
        this.output.setText(this.gameModel.getWelcomeMessage());
        this.theButton = new JButton("Do it");
        this.theButton.addActionListener(this);
        Box topBox = Box.createHorizontalBox();
        topBox.add(this.input);
        topBox.add(Box.createHorizontalStrut(20));
        topBox.add(this.theButton);
        this.setLayout(new BorderLayout());
        this.add((Component)topBox, "North");
        this.add((Component)new JScrollPane(this.output), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String inputLine = this.input.getText();
        Command command = Command.getCommand(inputLine);
        String result = this.gameModel.processCommand(command);
        if (result.equals("EXIT")) {
            System.exit(0);
        } else {
            this.output.append("--------------------------------\n");
            this.output.append(result + "\n");
            this.output.setCaretPosition(this.output.getText().length());
            this.input.setText("");
        }
    }

    public static void main(String[] args) {
        GameGUI theGame = new GameGUI();
        JFrame theFrame = new JFrame();
        theFrame.setTitle("Escape the Flames");
        Container cont = theFrame.getContentPane();
        cont.add((Component)theGame, "Center");
        theFrame.setBackground(Color.white);
        theFrame.pack();
        theFrame.setSize(new Dimension(800, 500));
        theFrame.setVisible(true);
        theFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

