/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Random;

public class GameModel {
    private Room startPoint;
    private Room outside;
    private Room bedArea;
    private Room dining;
    private Room kitchen;
    private Room family;
    private Room garage;
    private Room laundry;
    private Room groundBath;
    private Room smallHall;
    private Room master;
    private Room masterBath;
    private Room closet;
    private Room bed1;
    private Room bed2;
    private Room bed3;
    private Room upperBath;
    private Room hallway;
    private Room living;
    private ArrayList<Room> roomCollection = new ArrayList();
    private Player player;
    private int timer;
    private static int timeAllotted;
    private boolean hasWon;

    public GameModel() {
        this.createRooms();
        this.player = new Player(this.startPoint);
        timeAllotted = 75;
        this.hasWon = false;
    }

    public void resetGame() {
        this.roomCollection = new ArrayList();
        this.createRooms();
        this.player = new Player(this.startPoint);
        this.timer = timeAllotted;
        this.hasWon = false;
    }

    private void createRooms() {
        this.dining = new Room("in the dining room. Ground floor.");
        this.kitchen = new Room("in the kitchen. Ground floor.");
        this.family = new Room("in the family room. Ground floor.");
        this.garage = new Room("in the garage.Ground floor.");
        this.laundry = new Room("in the laundry room.Ground floor.");
        this.groundBath = new Room("in a half-bathroom.Ground floor.");
        this.living = new Room("in the living room.Ground floor.");
        this.smallHall = new Room("in a small hallway. Ground floor.");
        this.master = new Room("in the master Bedroom.Second floor.");
        this.masterBath = new Room("in the master bathroom. Second floor.");
        this.closet = new Room("in the master bedroom's walk-in closet.Second floor.");
        this.bed1 = new Room("in a large bedroom.Second floor.\nThe bed has smoke coming up from under it.");
        this.bedArea = new Room("beside the bed in the large bedroom.\nUnderneathyou see a hole.\nDo you go down it?");
        this.bed2 = new Room("in a cute little bedroom. Second floor.");
        this.bed3 = new Room("in a plain guest bedroom.  Second floor.");
        this.upperBath = new Room("in a full bathroom.  Second floor.");
        this.hallway = new Room("in a hallway. There are stairs to the ground floor, but flames consume them!");
        this.outside = new Room("in the great outdoors free from the burning building!!");
        this.dining.addExit("east", this.kitchen);
        this.dining.addItem("cookie", 0.0, "This is a special, burnt-resistant cookie.");
        this.kitchen.addExit("west", this.dining);
        this.kitchen.addExit("south", this.living);
        this.kitchen.addExit("east", this.family);
        this.kitchen.addItem("extinguisher", 10.0, "It is a bright red fire-extinguisher ready for use!");
        this.family.addExit("west", this.kitchen);
        this.family.addExit("south", this.smallHall);
        this.family.addItem("manual", 1.0, "A slightly singed paper manual. It looks important.");
        this.garage.addExit("west", this.laundry);
        this.garage.addItem("axe", 5.0, "A sturdy axe used for splitting firewood.");
        this.garage.addItem("spare-extinguisher", 10.0, "It is a bright red fire-extinguisher ready for use!");
        this.laundry.addExit("west", this.smallHall);
        this.laundry.addExit("east", this.garage);
        this.laundry.addExit("up", this.bed1);
        this.groundBath.addExit("north", this.smallHall);
        this.living.addExit("north", this.kitchen);
        this.smallHall.addExit("north", this.family);
        this.smallHall.addExit("east", this.laundry);
        this.smallHall.addExit("south", this.groundBath);
        this.master.addExit("northeast", this.masterBath);
        this.master.addExit("southeast", this.closet);
        this.master.addExit("south", this.hallway);
        this.master.addItem("telephone", 1.0, "A coordless phone.  There is a signal.");
        this.masterBath.addExit("west", this.master);
        this.closet.addExit("west", this.master);
        this.closet.addItem("fire-gear", 30.0, "This is authentic fireman gear.");
        this.bed1.addExit("north", this.hallway);
        this.bed1.addItem("bed", 500.0, "A small twin bed with a colorful quilt on top.");
        this.bedArea.addExit("down", this.laundry);
        this.bed2.addExit("south", this.hallway);
        this.bed2.addItem("flashlight", 1.0, "This is a high powered flashlight. \nGood for searching through dark places.");
        this.bed3.addExit("south", this.hallway);
        this.upperBath.addExit("north", this.hallway);
        this.hallway.addExit("north", this.master);
        this.hallway.addExit("north2", this.bed2);
        this.hallway.addExit("north3", this.bed3);
        this.hallway.addExit("south1", this.bed1);
        this.hallway.addExit("south", this.upperBath);
        this.startPoint = this.bed3;
        this.kitchen.setFire(true);
        this.dining.setFire(true);
        this.living.setFire(true);
        this.roomCollection.add(this.dining);
        this.roomCollection.add(this.kitchen);
        this.roomCollection.add(this.family);
        this.roomCollection.add(this.family);
        this.roomCollection.add(this.garage);
        this.roomCollection.add(this.laundry);
        this.roomCollection.add(this.groundBath);
        this.roomCollection.add(this.smallHall);
        this.roomCollection.add(this.master);
        this.roomCollection.add(this.masterBath);
        this.roomCollection.add(this.closet);
        this.roomCollection.add(this.bed1);
        this.roomCollection.add(this.bed2);
        this.roomCollection.add(this.bed3);
        this.roomCollection.add(this.upperBath);
        this.roomCollection.add(this.hallway);
    }

    public String getWelcomeMessage() {
        StringBuilder sb = new StringBuilder("");
        sb.append("Welcome to Escape the Flames!\n");
        sb.append("Escape the Flames is a new adventure game.\n");
        sb.append("You are in a burning building and must find an exit before");
        sb.append("\nthe building burns to the ground!  There is only one exit...");
        sb.append("\nthe main entrance through which you entered the building.");
        sb.append("\nMake your way there and get out!");
        sb.append("\nType '" + (Object)((Object)CommandWord.HELP) + "' if you need help.\n\n");
        sb.append(this.startPoint.getLongDescription() + "\n");
        return sb.toString();
    }

    public String getWinnerMessage() {
        StringBuilder sb = new StringBuilder("");
        sb.append("Congradulations!  You have escaped from\n");
        sb.append("the burning building!\n");
        sb.append("As you dash out, the structure collapses.\n");
        sb.append("You have beaten the odds!\n");
        sb.append("(RESTART/QUIT)");
        return sb.toString();
    }

    public String getLoserMessage() {
        StringBuilder sb = new StringBuilder("");
        sb.append("You have run out of time!\n");
        sb.append("The burning building collapses and you die.\n");
        sb.append("You have lost the game.  Better luck next time.\n");
        sb.append("(RESTART/QUIT)");
        return sb.toString();
    }

    public String getStandardMessage() {
        return this.player.getRoom().getShortDescription();
    }

    public void setTimer(int newCount) {
        this.timer = timeAllotted = newCount;
    }

    public int getTimeAllotted() {
        return timeAllotted;
    }

    public String processCommand(Command command) {
        CommandWord commandWord = command.getCommandWord();
        --this.timer;
        if (this.timer == 0 && !this.hasWon) {
            return this.getLoserMessage();
        }
        switch (commandWord) {
            case QUIT: {
                return this.quit(command);
            }
            case RESTART: {
                this.resetGame();
                return this.getWelcomeMessage();
            }
            case HELP: {
                return this.getHelpMessage();
            }
            case GO: {
                return this.goRoom(command);
            }
            case INSPECT: {
                return this.inspect(command);
            }
            case ITEMS: {
                return this.player.getItemsCarried();
            }
            case TAKE: {
                return this.take(command);
            }
            case DROP: {
                return this.drop(command);
            }
            case EAT: {
                return this.eat(command);
            }
            case USE: {
                return this.use(command);
            }
            case BACK: {
                return this.back(command);
            }
            case LOOK: {
                return this.look(command);
            }
            case TALK: {
                return this.talk(command);
            }
            case FOLLOW: {
                return this.follow(command);
            }
        }
        ++this.timer;
        return "I don't know what you mean...";
    }

    public String getHelpMessage() {
        StringBuilder sb = new StringBuilder("");
        sb.append("You are in a burning building! Find a way to\n");
        sb.append("escape before the building burns down!\n");
        sb.append("The main entrance is on the ground floor in the living room.\n");
        sb.append("Your command words are:\n");
        sb.append(CommandWord.getAllCommandWords() + "\n");
        sb.append(this.player.getRoom().getLongDescription());
        return sb.toString();
    }

    private String goRoom(Command command) {
        if (!command.hasSecondWord()) {
            return "Go where?";
        }
        String direction = command.getSecondWord();
        Room currentRoom = this.player.getRoom();
        Room nextRoom = currentRoom.getExit(direction);
        if (nextRoom == null) {
            return "There is no door!";
        }
        if (nextRoom.onFire()) {
            if (this.player.isProtected()) {
                this.player.setRoom(nextRoom);
                if (this.player.hasItem("flashlight")) {
                    return "This room is so thick with smoke that you can't see!\nGood thing you have a flashlight.\nDo you want to  USE it?";
                }
                return "This room is so smokey you can't see a thing!";
            }
            return "The room beyond this door is too hot!  You can't go through\nwithout some sort of protective gear.";
        }
        if (nextRoom.equals(this.living)) {
            if (this.living.onFire()) {
                if (this.player.isProtected()) {
                    this.player.setRoom(nextRoom);
                    if (this.player.hasItem("extinguisher")) {
                        return "You are in the living room.\nThe flames are intense around the entrance.Do you want to USE your\nextinguisher to put them out? You can only USE it once.";
                    }
                    return "You are in the living room.\nThe entrance door is on fire! Even with protective gear on,\nyou dare not fiddle with the burning entrance door.";
                }
                return "The room beyond this door is too hot!  You can't go through\nwithout some sort of protective gear.";
            }
            this.player.setRoom(nextRoom);
            return this.getStandardMessage() + "It appears that someone has " + "recently put out the fire in this room.";
        }
        if (nextRoom.equals(this.outside)) {
            return this.getWinnerMessage();
        }
        this.player.setRoom(nextRoom);
        return this.getStandardMessage();
    }

    private String inspect(Command command) {
        if (!command.hasSecondWord()) {
            return "Inspect what?";
        }
        String word2 = command.getSecondWord();
        if (word2.equals("bed")) {
            this.player.setRoom(this.bedArea);
            return this.getStandardMessage();
        }
        Item item = this.player.getRoom().getItem(word2);
        if (item == null) {
            return "There is nothing in this room for you to inspect.";
        }
        return item.getDescription();
    }

    private String take(Command command) {
        if (!command.hasSecondWord()) {
            return "Take what?";
        }
        return this.player.takeItem(command.getSecondWord());
    }

    private String drop(Command command) {
        if (!command.hasSecondWord()) {
            return "Drop what?";
        }
        return this.player.removeItem(command.getSecondWord());
    }

    private String eat(Command command) {
        if (!command.hasSecondWord()) {
            return "Eat what?";
        }
        return this.player.eat(command.getSecondWord());
    }

    private String use(Command command) {
        if (!command.hasSecondWord()) {
            return "Use what?";
        }
        String w = command.getSecondWord();
        if (w.equals("flashlight")) {
            if (this.player.hasItem("flashlight")) {
                return "Using the flashlight you see that\n" + this.getStandardMessage();
            }
            return "You have no such item.";
        }
        if (w.equals("extinguisher")) {
            if (this.player.hasItem("extinguisher")) {
                if (!this.player.getCarriedItem("extinguisher").getUsed()) {
                    this.player.getCarriedItem("extinguisher").setUsed(true);
                    if (this.player.getRoom().onFire()) {
                        this.player.getRoom().setFire(false);
                        if (this.player.getRoom().equals("living")) {
                            this.living.addExit("ESCAPE", this.outside);
                            return "You put out the flames around the entrance!";
                        }
                        return "You put out the fire in this room!";
                    }
                    return "You just wasted a fire-extinguisher!!";
                }
                return "You have already used this!  You can only use these things once.";
            }
            return "You have no such item";
        }
        if (w.equals("spare-extinguisher")) {
            if (this.player.hasItem("spare-extinguisher")) {
                if (!this.player.getCarriedItem("spare-extinguisher").getUsed()) {
                    this.player.getCarriedItem("spare-extinguisher").setUsed(true);
                    if (this.player.getRoom().onFire()) {
                        this.player.getRoom().setFire(false);
                        if (this.player.getRoom().equals("living")) {
                            this.living.addExit("ESCAPE", this.outside);
                            return "You put out the flames around the entrance!";
                        }
                        return "You put out the fire in this room!";
                    }
                    return "You just wasted a fire-extinguisher!!";
                }
                return "You have already used this!  You can only use these things once.";
            }
            return "You have no such item";
        }
        if (w.equals("telephone")) {
            if (this.player.hasItem("telephone")) {
                this.living.setFire(false);
                this.living.addExit("ESCAPE", this.outside);
                Random r = new Random();
                Room temp = this.roomCollection.get(r.nextInt(this.roomCollection.size()));
                temp.addNHC("fireman", "A well-prepared fireman to the rescue!");
                return "You called 911 and now there is a fireman looking for you.";
            }
            return "You have no such item.";
        }
        if (w.equals("fire-gear")) {
            if (this.player.hasItem("fire-gear")) {
                this.player.setProtection(true);
                return "You put on your fire gear and can go into hot places.";
            }
            return "You have no such item.";
        }
        return "That's useless.  Try something else.";
    }

    private String back(Command command) {
        if (command.hasSecondWord()) {
            return "I'm not sure what you mean.  If you want to go back\nto your previous location, just type 'back'.";
        }
        return this.player.retreat();
    }

    private String look(Command command) {
        if (command.hasSecondWord()) {
            return "I'm not sure what you mean.  If you want to look\naround the room, just type 'look'.";
        }
        if (!this.player.getRoom().onFire()) {
            return this.player.getRoom().getLongDescription();
        }
        return "The room is too smokey to see anything!  Do you have a flashlight?";
    }

    private String talk(Command command) {
        if (!command.hasSecondWord()) {
            return "Talk to whom?";
        }
        String w = command.getSecondWord();
        if (!this.player.getRoom().getNHC(w).equals(null)) {
            NHC character = this.player.getRoom().getNHC(w);
            return character.talk(w);
        }
        return "There is no one to talk to.";
    }

    private String follow(Command command) {
        if (!command.hasSecondWord()) {
            return "Follow what?";
        }
        String w = command.getSecondWord();
        if (!this.player.getRoom().getNHC(w).equals(null)) {
            NHC character = this.player.getRoom().getNHC(w);
            if (character.getName().equals("fireman")) {
                this.player.setRoom(this.outside);
                return this.getWinnerMessage();
            }
            return "You cannot follow" + character.getName();
        }
        return "There is no one to follow.";
    }

    private String quit(Command command) {
        if (command.hasSecondWord()) {
            return "I'm confused.  Do you want to QUIT?";
        }
        return "EXIT";
    }
}

