/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;

public class Player {
    private Room currentRoom;
    private double weightCapacity;
    private HashMap<String, Item> itemsCarried;
    private Stack<Room> roomLog;
    private boolean protection;
    private static final double MAX_WEIGHT = 35.0;

    public Player(Room startRoom) {
        this.currentRoom = startRoom;
        this.weightCapacity = 35.0;
        this.itemsCarried = new HashMap();
        this.roomLog = new Stack();
        this.protection = false;
    }

    public void setRoom(Room newRoom) {
        this.roomLog.push(this.currentRoom);
        this.currentRoom = newRoom;
    }

    public String retreat() {
        if (this.roomLog.isEmpty()) {
            return "You are at your original position!  It's just onward from here.";
        }
        this.currentRoom = this.roomLog.pop();
        if (!this.currentRoom.onFire()) {
            return this.currentRoom.getShortDescription();
        }
        return "You moved to the previous room,but it is too smokey to see anything.";
    }

    public Room getRoom() {
        return this.currentRoom;
    }

    public String takeItem(String item) {
        Item object = this.currentRoom.getItem(item);
        if (object == null) {
            return "There is no such item for you to pick up!";
        }
        if (this.weightCapacity > object.getWeight()) {
            this.itemsCarried.put(item, object);
            this.weightCapacity -= object.getWeight();
            return "You took " + this.currentRoom.removeItem(item).getName();
        }
        return "You are too weak to carry that!";
    }

    public String removeItem(String item) {
        if (this.itemsCarried.containsKey(item)) {
            if (item.equals("fire-gear") && this.currentRoom.onFire()) {
                return "You cannot take off your gear in here! It's too hot!";
            }
            this.currentRoom.addItem(this.itemsCarried.get(item));
            Item object = this.itemsCarried.get(item);
            this.itemsCarried.remove(item);
            this.weightCapacity += object.getWeight();
            return "You dropped " + item;
        }
        return "You do not have such an item.";
    }

    public String getItemsCarried() {
        StringBuffer sb = new StringBuffer("CARRIED ITEMS: ");
        if (this.itemsCarried.size() == 0) {
            sb.append("(none)");
            return sb.toString();
        }
        Set<String> itemSet = this.itemsCarried.keySet();
        for (String item : itemSet) {
            sb.append("\n" + item + "  " + this.itemsCarried.get(item).getWeight());
        }
        return sb.toString();
    }

    public boolean hasItem(String item) {
        return this.itemsCarried.containsKey(item);
    }

    public Item getCarriedItem(String item) {
        if (this.hasItem(item)) {
            return this.itemsCarried.get(item);
        }
        return null;
    }

    public String eat(String item) {
        if (this.itemsCarried.containsKey(item)) {
            if (item.equals("cookie")) {
                Item cookie = this.itemsCarried.get("cookie");
                this.itemsCarried.remove("cookie");
                this.weightCapacity = 100.0;
                return "You ate the special cookie! Now you can carry 100 lbs more of items!";
            }
            return "You cannot eat that.";
        }
        return "You do not have that.";
    }

    public boolean isProtected() {
        return this.protection;
    }

    public void setProtection(boolean protection) {
        this.protection = protection;
    }
}

