/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Set;

public class Room {
    private String description;
    private HashMap<String, Room> exits;
    private HashMap<String, Item> items;
    private HashMap<String, NHC> characters;
    private boolean fire;

    public Room(String description) {
        this.description = description;
        this.exits = new HashMap();
        this.items = new HashMap();
        this.characters = new HashMap();
        this.fire = false;
    }

    public void addExit(String direction, Room neighbor) {
        this.exits.put(direction, neighbor);
    }

    public void addItem(String name, double weight, String description) {
        Item newItem = new Item(name, weight, description);
        this.items.put(name, newItem);
    }

    public void addItem(Item item) {
        this.items.put(item.getName(), item);
    }

    public Item removeItem(String item) {
        if (this.items.containsKey(item)) {
            Item copy = this.items.get(item);
            this.items.remove(item);
            return copy;
        }
        return null;
    }

    public void addNHC(String name, String description) {
        NHC character = new NHC(name, description);
        this.characters.put(name, character);
    }

    public void addNHC(NHC character) {
        this.characters.put(character.getName(), character);
    }

    public NHC removeNHC(String character) {
        if (this.characters.containsKey(character)) {
            NHC copy = this.characters.get(character);
            this.characters.remove(character);
            return copy;
        }
        return null;
    }

    public String getShortDescription() {
        return "You are " + this.description;
    }

    public String getLongDescription() {
        StringBuffer buff = new StringBuffer();
        buff.append("You are " + this.description + "\n" + this.getExitString());
        if (this.items.size() != 0) {
            buff.append("\n" + this.getItemString());
        }
        if (this.characters.size() != 0) {
            buff.append("\n" + this.getNHCString());
        }
        return buff.toString();
    }

    private String getExitString() {
        String returnString = "EXITS:";
        Set<String> keys = this.exits.keySet();
        for (String exit : keys) {
            returnString = returnString + " " + exit;
        }
        return returnString;
    }

    public Room getExit(String direction) {
        return this.exits.get(direction);
    }

    private String getItemString() {
        String returnString = "ITEMS:";
        Set<String> keys = this.items.keySet();
        for (String item : keys) {
            returnString = returnString + "\n   " + item + "  " + this.items.get(item).getWeight() + " lbs";
        }
        return returnString;
    }

    public Item getItem(String name) {
        if (this.items.containsKey(name)) {
            return this.items.get(name);
        }
        return null;
    }

    private String getNHCString() {
        String returnString = "CHARACTER;";
        Set<String> keys = this.characters.keySet();
        for (String charac : keys) {
            returnString = returnString + "   " + charac;
        }
        return returnString;
    }

    public NHC getNHC(String name) {
        if (this.characters.containsKey(name)) {
            return this.characters.get(name);
        }
        return null;
    }

    public boolean onFire() {
        return this.fire;
    }

    public void setFire(boolean flames) {
        this.fire = flames;
    }
}

