import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
/**
 * A simple applet that demonstrates the difference between 
 * storing integers as Strings versus in binary form.
 */
//----------------------------------------------------------------------------
public class TextVersusBinary extends JFrame {

  JTextField[] element = null;
  int[] A;

  // The textArea which holds the array in string form
  JTextArea SText = new JTextArea();
  // The textArea which holds the array in binary form
  JTextArea BText = new JTextArea();
  // The box which holds the array elements
  Box AText;

//----------------------------------------------------------------------------
  public TextVersusBinary() {
          
    JButton S2AButton = new JButton("String2Array");
    JButton A2SButton = new JButton("Array2String");
    Box buttonBox1=Box.createHorizontalBox();

    buttonBox1.add(Box.createHorizontalGlue());
    buttonBox1.add(S2AButton);
    buttonBox1.add(Box.createHorizontalGlue());
    buttonBox1.add(A2SButton);
    buttonBox1.add(Box.createHorizontalGlue());
    
    JButton A2BButton = new JButton("Array2Binary");
    JButton B2AButton = new JButton("Binary2Array");
    Box buttonBox2=Box.createHorizontalBox();
    
    buttonBox2.add(Box.createHorizontalGlue());
    buttonBox2.add(A2BButton);
    buttonBox2.add(Box.createHorizontalGlue());
    buttonBox2.add(B2AButton);
    buttonBox2.add(Box.createHorizontalGlue());

    AText=Box.createHorizontalBox();
    JLabel arrayLabel=new JLabel("A=");
    AText.add(arrayLabel);

    Box mainBox=Box.createVerticalBox();
    mainBox.add(SText);
    mainBox.add(buttonBox1);
    mainBox.add(AText);
    mainBox.add(buttonBox2);
    mainBox.add(BText);
    BText.setEditable(false);
    
    setTitle("Strings and Arrays and Binary Files");
    Container contentPane = this.getContentPane();
    
    contentPane.add(mainBox);
    
    setSize(new Dimension(400,200));
    pack();
    setSize(new Dimension(400,200));
    setVisible(true);
    
    //----------------------------------------------------
    // Adding the ActionListeners to the buttons.
    S2AButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String2Array();
        validate();
      } });
    A2SButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        Array2String();
        validate();
      } });
    A2BButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        Array2Binary();
        validate();
      } });
    B2AButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        Binary2Array();
        validate();
      } });
  }  
//----------------------------------------------------------------------------
  public static void main(String[] args) {
      new TextVersusBinary();
  }
//----------------------------------------------------------------------------
  public void Array2String() {
        SText.setText("");
        if(element!=null) {
          for(int i=0;i<element.length;i++) {
              A[i]=Integer.parseInt(element[i].getText());
          }
        SText.setText(IntArrayToString(A));
        }
  }
//----------------------------------------------------------------------------
  public void String2Array() {
       if(element!=null) {
           for(int i=0;i<element.length;i++) {
               AText.remove(element[i]);
           }
       }
       A=StringToIntArray(SText.getText());
       element=new JTextField[A.length];
       for(int i=0;i<A.length;i++) {
           element[i]=new JTextField(A[i]+"");
           AText.add(element[i]);
       }
  }
//----------------------------------------------------------------------------
  public void Array2Binary() {
    try {
       BText.setText("");
       FileOutputStream FS=new FileOutputStream("blah");
       DataOutputStream DS=new DataOutputStream(FS);
       if(element!=null) {
           for(int i=0;i<element.length;i++) {
               A[i]=Integer.parseInt(element[i].getText());
               DS.writeInt(A[i]);
           }
       }
       DS.close();
       FileInputStream IFS=new FileInputStream("blah");
       DataInputStream IDS=new DataInputStream(IFS);
       while(true) {
            BText.append(""+(char)IDS.readByte());
       }
    }
    catch(EOFException e) {
    }
    catch(IOException e) {
    }
  }
//----------------------------------------------------------------------------
  public void Binary2Array() {
     try {
        if(element!=null) {
            for(int i=0;i<element.length;i++) {
                AText.remove(element[i]);
            }
        }
        A=new int[BText.getText().length()/4];
        element=new JTextField[A.length];
   
        FileInputStream FS=new FileInputStream("blah");
        DataInputStream DS=new DataInputStream(FS);
        for(int i=0;i<A.length;i++) {
            A[i]=DS.readInt();
            element[i]=new JTextField(A[i]+"");
            AText.add(element[i]);
        }
    }
    catch(IOException e) {
    }
  }
//----------------------------------------------------------------------------
  public int[] StringToIntArray(String S) {
       StringTokenizer T=new StringTokenizer(S," ");
       int[] ans=new int[T.countTokens()];
       for(int i=0;i<ans.length;i++) {
          ans[i]=Integer.parseInt(T.nextToken());
       }
       return ans;
  }
//----------------------------------------------------------------------------
  public String IntArrayToString(int []A) {
       StringBuffer S=new StringBuffer();
       for(int i=0;i<A.length;i++) {
          S.append(A[i]+" ");
       }
       return new String(S);
  }
//----------------------------------------------------------------------------
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }
//----------------------------------------------------------------------------
}
