import java.util.*;

/**
 * An interface for an object that listens for ClockEvents.
 * It allows object to know when the time changes, when the
 * alarm goes off, and when the alarm stops going off.
 * 
 * @author Charles Cusack 
 * @version August, 2008
 */
public interface ClockListener extends EventListener
{

    /**
     * Invoked when the time changes
     */
    public void timeChanged(ClockEvent e);
    
    /**
     * Invoked when the alarm goes off
     */
    public void alarm(ClockEvent e);
    
    /**
     * Invoked when the alarm stops going off
     */
    public void alarmEnded(ClockEvent e);
}
