/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

class BarChart
extends JPanel {
    int listSize = 0;
    int[] list;
    double average;
    int bufferSize = 10;
    Color color = Color.red;

    public void clearData() {
        this.listSize = 0;
        this.repaint();
    }

    public void updateData(int length, int[] data, double average) {
        this.listSize = length;
        this.list = data;
        this.average = average;
        this.repaint();
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        if (this.listSize == 0) {
            return;
        }
        g.setColor(this.color);
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int barWidth = panelWidth / this.listSize - this.bufferSize;
        int max = 0;
        for (i = 0; i < this.listSize; ++i) {
            if (this.list[i] <= max) continue;
            max = this.list[i];
        }
        for (i = 0; i < this.listSize; ++i) {
            int x = this.bufferSize / 2 + i * (barWidth + this.bufferSize);
            int y = (int)((double)panelHeight * 1.0 / (double)max * (double)(max - this.list[i]));
            int h = panelHeight - y;
            g.fillRect(x, y, barWidth, h);
        }
        g.setColor(Color.black);
        int y = (int)((double)panelHeight * 1.0 / (double)max * ((double)max - this.average));
        g.drawLine(0, y, panelWidth, y);
        g.drawString("Average", 100, y - 5);
    }
}

