/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ListAverage
implements ActionListener {
    private int width = 800;
    private int height = 600;
    int listSize;
    int[] theList;
    double average;
    JFrame theFrame;
    JTextField theInputField;
    JTextField colorField;
    JTextArea listArea;
    JTextField averageField;
    BarChart listChart;
    HashMap<String, Color> colorMap = new HashMap();

    public static void main(String[] args) {
        ListAverage la = new ListAverage();
    }

    private void addColors() {
        this.colorMap.put("red", Color.red);
        this.colorMap.put("orange", Color.orange);
        this.colorMap.put("blue", Color.blue);
        this.colorMap.put("yellow", Color.yellow);
        this.colorMap.put("green", Color.green);
        this.colorMap.put("black", Color.black);
        this.colorMap.put("pink", Color.pink);
        this.colorMap.put("gray", Color.gray);
    }

    public String getColorList() {
        StringBuffer theList = new StringBuffer();
        Set<String> colors = this.colorMap.keySet();
        for (String colorName : colors) {
            theList.append(colorName + ", ");
        }
        return theList.substring(0, theList.length() - 2);
    }

    public ListAverage() {
        this.addColors();
        this.theFrame = new JFrame();
        this.theFrame.setTitle("ListAverage");
        this.theFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JMenuBar jmb = new JMenuBar();
        this.theFrame.setJMenuBar(jmb);
        JMenu fileMenu = new JMenu("File");
        jmb.add(fileMenu);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(exitItem);
        JMenu editMenu = new JMenu("Edit");
        jmb.add(editMenu);
        JMenuItem colorItem = new JMenuItem("Color");
        colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(ListAverage.this.theFrame, "Choose Chart Color", ListAverage.this.listChart.getColor());
                if (newColor != null) {
                    ListAverage.this.listChart.setColor(newColor);
                }
            }
        });
        editMenu.add(colorItem);
        JMenu helpMenu = new JMenu("Help");
        jmb.add(helpMenu);
        JMenuItem instructionsItem = new JMenuItem("Instructions");
        instructionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(ListAverage.this.theFrame, "Input a list of integers separated by spaces.\nHit 'Compute' to see the list of numbers andthe average.\nHit 'Clear' to clear the input and output.\nEnter a color and hit 'Change Color' to change color of the bar chart.\nThere is more, but you can figure it out.", "List Average Instructions", 1);
            }
        });
        helpMenu.add(instructionsItem);
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(ListAverage.this.theFrame, "Written by me.", "List Average 1.0", 1);
            }
        });
        helpMenu.add(aboutItem);
        this.theInputField = new JTextField(35);
        JButton computeAverageButton = new JButton("Compute");
        computeAverageButton.addActionListener(this);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListAverage.this.theInputField.setText("");
                ListAverage.this.listArea.setText("");
                ListAverage.this.averageField.setText("");
                ListAverage.this.colorField.setText("");
                ListAverage.this.listChart.clearData();
            }
        });
        this.colorField = new JTextField(5);
        this.colorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String colorName = ListAverage.this.colorField.getText().toLowerCase();
                Color theColor = ListAverage.this.colorMap.get(colorName);
                if (theColor == null) {
                    JOptionPane.showMessageDialog(ListAverage.this.theFrame, "Please enter one of the following colors:\n" + ListAverage.this.getColorList(), "Invalid Color!", 0);
                } else {
                    ListAverage.this.listChart.setColor(theColor);
                }
            }
        });
        JButton colorButton = new JButton("Change Color");
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String colorName = ListAverage.this.colorField.getText().toLowerCase();
                Color theColor = ListAverage.this.colorMap.get(colorName);
                if (theColor == null) {
                    JOptionPane.showMessageDialog(ListAverage.this.theFrame, "Please enter one of the following colors:\n" + ListAverage.this.getColorList(), "Invalid Color!", 0);
                } else {
                    ListAverage.this.listChart.setColor(theColor);
                }
            }
        });
        JPanel inputPanel = new JPanel();
        inputPanel.add(Box.createHorizontalStrut(5));
        inputPanel.add(this.theInputField);
        inputPanel.add(computeAverageButton);
        inputPanel.add(clearButton);
        inputPanel.add(Box.createHorizontalStrut(20));
        inputPanel.add(this.colorField);
        inputPanel.add(colorButton);
        inputPanel.add(Box.createHorizontalStrut(5));
        this.listArea = new JTextArea(30, 10);
        this.listArea.setBorder(new TitledBorder("The list"));
        this.listArea.setEditable(false);
        this.averageField = new JTextField(5);
        this.averageField.setEditable(false);
        this.averageField.setBorder(new TitledBorder("The average"));
        Box outputBox = Box.createVerticalBox();
        outputBox.add(this.listArea);
        outputBox.add(this.averageField);
        this.listChart = new BarChart();
        JPanel chartPanel = new JPanel();
        chartPanel.setLayout(new BorderLayout());
        chartPanel.setBorder(new TitledBorder("The Chart"));
        chartPanel.add((Component)this.listChart, "Center");
        Container cont = this.theFrame.getContentPane();
        this.theFrame.setLayout(new BorderLayout());
        this.theFrame.add((Component)inputPanel, "North");
        this.theFrame.add((Component)outputBox, "West");
        this.theFrame.add((Component)chartPanel, "Center");
        this.theFrame.pack();
        this.theFrame.setSize(new Dimension(this.width, this.height));
        this.theFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String numbers = this.theInputField.getText();
        StringTokenizer st = new StringTokenizer(numbers);
        int listSize = st.countTokens();
        if (listSize == 0) {
            JOptionPane.showMessageDialog(this.theFrame, "Please input Some integers and try again.", "No input!", 0);
        }
        this.theList = new int[listSize];
        this.average = 0.0;
        try {
            int i;
            for (i = 0; i < listSize; ++i) {
                this.theList[i] = Integer.parseInt(st.nextToken());
                if (this.theList[i] < 0) {
                    throw new NumberFormatException("No negatives");
                }
                this.average += (double)this.theList[i];
            }
            this.average /= (double)listSize;
            if (listSize > 0) {
                for (i = 0; i < listSize; ++i) {
                    this.listArea.append(this.theList[i] + "\n");
                }
                DecimalFormat df = new DecimalFormat("########.######");
                this.averageField.setText("" + df.format(this.average));
            }
            this.listChart.updateData(listSize, this.theList, this.average);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.theFrame, "Please input only positive integers and try again.", "Invalid input", 0);
            listSize = 0;
            this.listArea.setText("");
            this.averageField.setText("");
            this.listChart.clearData();
        }
    }
}

