// runSorts.cpp
// A program that runs 6 different sorting algorithms on various data and
// outputs data that allows the algorithms to be compared.
//
// YOU SHOULD NOT MOFIDY THIS FILE AT ALL!!!!
//
// Charles A. Cusack, September, 2003
// Revised, February, 2008
//-------------------------------------------------------------------------
//#include<sys/times.h>
#include<chrono>
#include<math.h>
#include "INTEGER.h"
#include "sortAlgorithms.h"
#include "listGenerator.h"
//-------------------------------------------------------------------------
void doSort(int k,INTEGER *A,int n);
void outputAlgorithmName(int i);
//-------------------------------------------------------------------------

int main (int argc,char* argv[]) {
typedef std::chrono::high_resolution_clock Clock;


if(argc!=3 ) {       // Check for correct number of command line arguments.
    cout<<"USAGE: "<<argv[0]<<" dataset seed\n"; 
    cout<<"where dataset is a specification file for tests to run\n";
    return(1); 
}

//------------------------------------------------------------------------
// Seed the random number generator
int seed=atoi(argv[2]);
//------------------------------------------------------------------------
// Open the test cases input file
ifstream datafile(argv[1]);
int tests;
datafile>>tests;

//------------------------------------------------------------------------
// Set up the acccounting variables
int numAlgs=3;
int inputTypes=5;

// Counts for the sorts
int typeCount[inputTypes+1];
double costs[numAlgs][inputTypes+1];

for(int i=0;i<=inputTypes;i++) {
   typeCount[i]=0;
   }
for(int i=0;i<numAlgs;i++) {
   for(int j=0;j<=inputTypes;j++) {
      costs[i][j]=0;
   }
}

//------------------------------------------------------------------------
// The variable used by the list generator functions
char type;   // data type
int intType;   // data type
int mod;     // modulus for algorithms with mod.
int shift;   //end of clump
int percent; // clump percentage
int start;   // start of clump
int end;     //end of clump


//------------------------------------------------------------------------
// The variables used to store the arrays, etc.
int n;            //number of elements to sort
INTEGER* A=NULL;  // The array of elements to sort
INTEGER* B=NULL;  // The array the algorithms will sort
INTEGER* C=NULL;  // The array that will store the correct sorted array

//------------------------------------------------------------------------
// Print the header for the output of each trial.
cout<<"Algorithm Type Size OperCount     CPUTime     Score\n";
cout<<"-------------------------------------------------\n";

//------------------------------------------------------------------------
// Runs all of the trials
for(int i=0;i<tests;i++) {
     datafile>>type;          // Read the line from the file to determine
     datafile>>n;             // Type and size of input
     if(type=='m' || type=='c') { // Get additional information if needed
        datafile>>mod;
        datafile>>shift;
     }
     if(type=='c') {
        datafile>>percent;
        datafile>>start;
        datafile>>end;
     }
     //------------------------------------------------------------------------
     // Generate a random list to test with
     srand(seed);  // Seed the generator with the previously saved seed.
                  // See below why this is done.
     switch(type) {
     case 'i':  
         A=inorder(n);
         intType=0;
         break;
     case 'I':  
         A=almostInorder(n);
         intType=0;
         break;
     case 'o':  
         A=outorder(n);
         intType=1;
         break;
     case 'O':  
         A=almostOutorder(n);
         intType=1;
         break;
     case 'r':  
         A=randomlist(n);
         intType=2;
         break;
     case 'm':  
         A=randomlistMod(n,mod,shift);
         intType=3;
         break;
     case 'c':  
         A=clump(n,mod,shift,percent,start,end);
         intType=4;
         break;
     default:  
         A=randomlist(n);
         intType=2;
     }
     seed=rand(); // Store the seed so we can re-seed the generator with the
                  // same seeds.  This is used in case someone uses rand() in
                  // their sorting algorithm, which would make the lists 
                  // generated for them different than those who do not use rand.
     typeCount[intType]++;
     typeCount[inputTypes]++;

     //------------------------------------------------------------------------
     // Sort the list once with known correct algorithm.
     // Use it later to check that the others are correct.
     if(C!=NULL) {
         delete []C;
     }
     C=new INTEGER[n];
     for(int l=0;l<n;l++) {
         C[l]=A[l];
     }
     // I am using the UNIX qsort to generate the correct answer for each array.
     // You are certainly NOT allowed to call this or any other utility sort
     // algorithm.  I am using this because, unlike your algorithms, I know
     // that it actually works.
     qsort((void *)C,n,sizeof(INTEGER),INTcompare);

     for(int i=0;i<numAlgs;i++) {
          //--------------------------------------------------------------------
          // Copy the array so it can be sorted multiple times
          if(B!=NULL) delete []B;
          B=new INTEGER[n];       // Copy data so it can be used later.
          for(int k=0;k<n;k++)  
             B[k]=A[k];

          //--------------------------------------------------------------------
          // Start the timers, run the sort, stop the timers
          INTEGER::reset_counters(); // Reset the counters so they don't count 
                                            // operations used to create lists.
          //hrtime_t startTime,endTime;
          //startTime=gethrtime();
          auto startTime =Clock::now();

          doSort(i,B,n); // Perform the ith sort.

          //endTime=gethrtime();
          //hrtime_t totalTime=endTime-startTime;
          auto endTime =Clock::now();
          auto elapsedTime =std::chrono::duration_cast<std::chrono::nanoseconds>(endTime - startTime).count();

          //--------------------------------------------------------------------
          // Check that the algorithm actually sorted the array correctly
          int k=0;
          while(k<n && B[k]==C[k])  {
               k++;
          }
          if(k!=n)  {
             cout<<"Sort did not work.  Terminating.\n";
             return(1);
          }

          //--------------------------------------------------------------------
          // Compute and store the running time of the algorithm.
                                                            // Scale by nlog(n).
          double scale=log( (double) 2)/(n*log( (double) n));
          // Operation count
          double OperationCount=INTEGER::get_total()*scale;
                                               // Time used divided by n log(n).
                               // Also scale CPUTime by a factor of 96.
                               // This makes OperationCount and CPUTime about
                               // the same for a good implementation of
                               // quicksort.
          double CPUTime=elapsedTime*scale/6.5;
                      // The score is the average of OperationCount and CPUTime.
          double score=(OperationCount+CPUTime)/2;

          costs[i][intType]+=score;
          costs[i][inputTypes]+=score;

          //--------------------------------------------------------------------
          // Output the details of this trial

          outputAlgorithmName(i);
          cout.width(2);
          cout<<type;
          cout.width(8);
          cout<<n;
          cout.width(10);
          cout<<OperationCount;
          cout.width(12);
          cout<<CPUTime;
          cout.width(10);
          cout<<score;
          cout<<"\n"<<flush;

          if(B!=NULL) {
              delete []B;                      // Get rid of the sorted array.
              B=NULL;
              }
     }
     cout<<"-------------------------------------------------\n";
     if(A!=NULL) {
        delete []A;                      // Get rid of the sorted array.
        A=NULL;
     }
     if(C!=NULL) {
        delete []C;                      // Get rid of the sorted array.
        C=NULL;
     }
   }

    //-------------------------------------------------------------------------
    // Print out the results
    cout<<"\n\n";
    cout<<"           ";
    cout<<"In Order      Reversed        Random      Repeated";
    cout<<"       Clumped       Average\n";
    for(int i=0;i<numAlgs;i++) {
       outputAlgorithmName(i);
       for(int j=0;j<=inputTypes;j++) {
       cout.width(10);
       if(costs[i][j]!=0)
            cout<<costs[i][j]/typeCount[j]<<" ("<<typeCount[j]<<")";
       else
         cout<<"No Data";
    }
    cout<<"\n";
    //-------------------------------------------------------------------------
}

datafile.close();

return 0;
}
//-------------------------------------------------------------------------
void doSort(int k,INTEGER *A,int n) {
switch (k) {
    case 0:
       merge_sort(A,0,n-1);
       break;
    case 1:
       quick_sort(A,0,n-1);
       break;
    case 2:
       your_sort(A,0,n-1);
       break;
    default:
       break;
    }
}
//-------------------------------------------------------------------------
void outputAlgorithmName(int i) {
    string sorts[4];
    sorts[0]="Merge   ";
    sorts[1]="Quick   ";
    sorts[2]="Yours   ";
    sorts[3]="Invalid ";
    if(i>=0 && i<3) {
       cout<<sorts[i];
    } else {
       cout<<sorts[3];
    }
}
//-------------------------------------------------------------------------

