//-------------------------------------------------------------------------
#include "yourSorts.h"
#include "util.h"
//-------------------------------------------------------------------------
//Written by Chuck Cusack, 2003.
//Modified by Chuck Cusack, 2008, 2015
//
// Here is the implementation of several standard sorting algorithms.
// Your job is to make them better.
//

//-------------------------------------------------------------------------
void bubble_sort2(int *Array,int l,int r) {
    for (int i=l;i<r;i++) {              // The BubbleSort Algorithm.
        for (int j=l;j<r-i;j++) {
            if (Array[j+1] < Array[j]) {
               Swap(Array[j],Array[j+1]);
               }
            }
        }
}
//-------------------------------------------------------------------------
void selection_sort2(int *Array,int l, int r) {
    for (int i=l;i<r;i++) {          // The Selection Sort Algorithm.
        int min = i;
        for (int j=i+1;j<=r;j++) {
            if (Array[j] < Array[min]) min = j;
            }
        Swap(Array[i],Array[min]);
        }
}
//-------------------------------------------------------------------------
void insertion_sort2(int *A,int l,int r) {
        int temp;
        int i;
        for (int j=l+1;j<=r;j++) {        // The Insertion Sort Algorithm.
            temp=A[j];
            i=j-1;
            while (i>=l && temp < A[i]) {
                   A[i+1]=A[i];
                   i--;
                   }
            A[i+1]=temp;
            }
}
//-------------------------------------------------------------------------
void quick_sort2(int *A,int l,int r) {
    if(l<r) {
       int p=partition2(A,l,r);
       quick_sort2(A,l,p-1);
       quick_sort2(A,p+1,r);
   }
}
//-------------------------------------------------------------------------
int partition2(int *A, int l, int r) {
    int p;
    p = A[l];
    int i = l+1;
    int j = r;
    while (1) {
        while (A[i] <= p && i < r) ++i;
        while (A[j] >= p && j > l) --j;
        if (i >= j) {
           Swap(A[j],A[l]);
           return j;
           }
        else {
             Swap(A[i],A[j]); 
             }
        }
}
//-------------------------------------------------------------------------
void merge_sort2(int *A,int l,int r) {
    if(l<r) {
        int mid = (l+r)/2;
        merge_sort2(A, l, mid);
        merge_sort2(A, mid + 1, r);
        merge2(A, l, mid, r);
    }
}
//-------------------------------------------------------------------------
void merge2(int *A,int l,int m,int r) {
    int size=r-l+1; 
    int mid=m-l+1;
    int *B=new int[size];
    for(int i=0;i<mid;i++)
       B[i]=A[l+i];
    int blah=r+mid;
    for(int j=mid;j<size;j++)
       B[j]=A[blah-j];
    int i=0;
    int j=size-1;
    for(int k=l;k<=r;k++) {
       if(B[i]<B[j]) {
         A[k]=B[i];
         i++;
       }
       else {
         A[k]=B[j];
         j--;
       }
    }
    delete []B;
}
//-------------------------------------------------------------------------
