/**
 * Vector.java
 *
 * A class that represents a column or row vector.
 * It implements most of the operations you would want to perform on a Vector
 *
 * @author Class skeleton and a few methods written by Charles Cusack.
 *
 */

public class Vector {    

    // The elements of this vector.
    private double[] elements;

    // Do you need any more fields?

    /**
     * Constructor a Vector with the specified number of elements.  
     * The values should be initialized to all zeroes.
     *
     * (This one is done)
     *
     * @param numberElements the number of elements in the vector.
     */
    public Vector (int numberElements) 
    {
        elements = new double[numberElements];
    }
    
    /**
     * Constructor a Vector with the specified elements.  
     * Note: These values should be copied into the new array--in
     * other words, you cannot simply do:
     * elements = intitialValues.
     * Hint:  You will need a loop.
     *
     * @param initialValues the values that should be stored in the vector.
     */
    public Vector (double[] initialValues) 
    {
    }
    
    /**
     * Set all of the values in this vector to zero.
     *
     */
    public void zero()
    {
    }


    /**
     * Sets the value of the ith component to the specified value
     *
     * @param i the index of the component to change
     * @param value the new value for the component
     * @return returns the old value stored at component i if
     *      0 <= i < getSize(), and Double.NaN otherwise.
     */
    public double setValueAt (int i, double value) 
    {
        return 0; // Just so it compiles--replace...
    }
    
    /**
     * Gets the value of the ith component of this vector
     *
     * @param i the index of the component to retrieve
     * @return returns the value stored at component if
     *      0 <= i < getSize(), and Double.NaN otherwise.
     */
    public double getValueAt (int i)
    {
        return 0; // Just so it compiles--replace...
    }
        
    /**
     * Computes the number of components (or elements) of the vector
     *
     * @return an integer indicating the number of components in this vector
     */
    public int getSize ()
    {
        return 0; // Just so it compiles--replace...
    }

    /**
     * Calculates the length of the Vector.  This is not the number of elements
     * in the vector, but the square root of the sum of the squares of the elements.
     *
     * @return a double value indicating the length of the vector
     */
    public double length () 
    {
        return 0; // Just so it compiles--replace...
    }

    /**
     * Compute and return the dot product of this vector and v. For instance,
     * if this vector is [u1 u2, u3] and v = [v1, v2, v3], the dot product is
     * u1*v1 + u2*v2 + u3*v3.
     *
     * @return a double value corresponding to the dot product of this 
     *     vector and v, or Double.NaN if the Vectors do not have the same size.
     *
     */
    public double dotProduct (Vector v)
    {
        return 0; // Just so it compiles--replace...
    }


    /**
     * Computes and returns the vector corresponding to this + v.
     * if this vector is [u1 u2, u3] and v = [v1, v2, v3], it returns
     * the vector [u1+v1, u2+v2, u3+v3]
     *
     * @return the sum of this vector and v, or null if the Vectors 
     *    do not have the same size.
     */
    public Vector add (Vector v) 
    {
        return null; // Just so it compiles--Replace...
    }

    /**
     * Computes and returns the vector corresponding to this - v.
     * if this vector is [u1 u2, u3] and v = [v1, v2, v3], it returns
     * the vector [u1-v1, u2-v2, u3-v3]
     *
     * @return the difference of this vector and v, or null if the Vectors 
     *    do not have the same size.
     *
     */
    public Vector subtract (Vector v) 
    {
        return null; // Just so it compiles--Replace...
    }

    /**
     * Computes and returns the vector corresponding to this * scalar.
     * if this vector is [u1 u2, u3], it returns
     * the vector [scalar*u1, scalar*u2, scalar*u3]
     *
     * (This one is done)
     *
     * @return the product of scalar a and this vector and v.
     *
     */
    public Vector scalarMultiply(double scalar) 
    {
        // Get a new vector of the same size.
        Vector toReturn = new Vector(this.getSize());
        // Now go through each element of the array/Vector
        for(int i=0;i<this.getSize();i++)
        {
            // Assign to each element of the new Vector the 
            // element from this Vector times the scalar.
            toReturn.setValueAt(i,scalar*this.getValueAt(i));
            // You could replace the above line with this:
            // toReturn.elements[i] = scalar*this.elements[i];
            // Just two different ways of doing the same thing.
            // Each has an advantage and a disadvantage.
        }
        // Of course, we return the newly created Vector.
        return toReturn;
        
        // You could also implement this method as follows:
        // double[] newValues = new double[elements.length];
        // for(int i=0;i<elements.length;i++)
        // {
        //    newValues[i] = scalar*elements[i];    
        // }
        // return new Vector(newValues);
    }
    /**
     * Return the normalized version of this vector.  
     * In other words, the equivalent vector of unit length.
     * That is, the vector produced by dividing every element
     * of this vector by the length (not size) of this vector.
     *
     * If this Vector is the zero vector, it should just return 
     * a copy of this vector since it cannot be normalized.
     *
     * @return the normalized version of this vector.
     */
    public Vector normalize () 
    {
        return null; // Just so it compiles--Replace...
    }
    

    /**
     * Determines whether this Vector is equal to another one
     * Two vectors are equal if they have the same size, and each element has the same value
     *
     * @param other the object we want to compare to this one.
     * @return true if other is a vector and this vector should be considered equal to other,
     * false otherwise
     */
    public boolean equals (Object other) 
    {
        // First, make sure we are comparing apples to apples--
        // well, Vectors to Vectors in this case.
        if (!(other instanceof Vector)) 
        {
            return false;
        }
        // Since we know that other is a Vector, we can "cast" it into
        // one--this allows us to treat otherVector like a vector.
        Vector otherVector = (Vector) other;

        // For the remainder of this method, use otherVector, not other.

        //
        // THIS ONE IS NOT DONE!  YOU NEED TO FINISH IT!
        //
        // Finish me. (The logical next steps:  Are they the same size?  
        //             Do they have the same elements?)

        return false; // Just so it compiles--replace...
    }

    /**
     * Return a string representation of this vector, using parentheses.
     * If this vector is [u1 u2, u3], it should print:
     * [u1, u2, u3]
     *
     * @return the string representation of this vector.
     */
    public String toString () 
    {
        return null; // Just so it compiles--Replace...
    }
}
