import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Scanner;

/**
 * 
 * ---------------------------------------------------------------------------
 * A GUI front end for the game. 
 * This class was added.  
 * It uses the getCommand method that was in Parser with just a few slight
 * modifications (so the input comes from a GUI element instead of standard
 * input).  
 * Notice that the Parser class is gone.  I decided that it was not needed
 * because 
 * ---------------------------------------------------------------------------
 * 
 * 
 * @author Charles Cusack
 * @version October, 2008
 */
public class GameGUI extends JPanel implements ActionListener
{
    // The GUI elements
    private JTextField input;
    private JButton theButton;
    private JTextArea output;
    
    // The game related stuff.
    private GameModel gameModel; // The model of the game
    
    /**
     * Constructor for objects of class Game
     */
    public GameGUI()
    {
        gameModel = new GameModel();
        
        input = new JTextField(30);
        input.addActionListener(this);
        
        output = new JTextArea(10,10);
        output.setEditable(false);
        output.setText(gameModel.getWelcomeMessage());
        theButton = new JButton("Do it");
        theButton.addActionListener(this);
        
        Box topBox = Box.createHorizontalBox();
        topBox.add(input);
        topBox.add(Box.createHorizontalStrut(20));
        topBox.add(theButton);
        
        setLayout(new BorderLayout());
        add(topBox,BorderLayout.NORTH);
        add(new JScrollPane(output),BorderLayout.CENTER);
    }
    
    public void actionPerformed(ActionEvent e) {
        String inputLine = input.getText();
        Command command = Command.getCommand(inputLine);
        String result = gameModel.processCommand(command);
        if(result.equals("EXIT")) {
            System.exit(0);
        } else {
            output.append("--------------------------------\n");
            output.append(result+"\n");
            output.setCaretPosition(output.getText().length());
            input.setText("");
        }
    }
    
    public static void main(String[] args)
    {
        GameGUI theGame = new GameGUI();
        
        JFrame theFrame = new JFrame();
        theFrame.setTitle("World of Zuul");
        
        // Place all of the graphical components on the main window
        Container cont=theFrame.getContentPane();
        cont.add(theGame,BorderLayout.CENTER);
  
        // Finish setting up the main window
        theFrame.setBackground(Color.white);
        theFrame.pack(); 
        theFrame.setSize(new Dimension(400,500));
        theFrame.setVisible(true);         
        
        // Add window listener so it closes properly.
        theFrame.addWindowListener
        (
            new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            }
        );  
    }
    
    
}
