import java.util.Scanner;
/**
 * A command-line based implementation of the game.
 * 
 * @author Charles Cusack
 * @version October, 2008
 */
public class GameTXT extends Object
{
    private GameModel gameModel; // The model of the game
    private Scanner reader; // To read in the input
    
    /**
     * Constructor for objects of class GameTXT
     */
    public GameTXT()
    {
        gameModel = new GameModel(); // create the game model
        reader = new Scanner(System.in); // create the reader
        playGame(); // play the game.  Duh.
    }
    public void playGame()
    {
        // Print the welcome message
        System.out.println(gameModel.getWelcomeMessage());
        
        // Enter the main command loop.  Here we repeatedly read commands and
        // execute them until the game is over.
        String output = "";
        while (!output.equals("EXIT")) {
            System.out.println(output);                      // print out results.
            System.out.print("> ");                          // print prompt
            String inputLine = reader.nextLine();            // get input
            Command command = Command.getCommand(inputLine); // get command based on input
            output = gameModel.processCommand(command);      // process command
        }
        System.out.println("Thank you for playing.  Good bye.");
    }
    
    public static void main(String[] args)
    {
        new GameTXT();
    }
}
