// Hanoi.cc
// A class to store the current state of the Towers of Hanoi puzzle.
//
//-------------------------------------------------------------------
#include "hanoi.h"
//-------------------------------------------------------------------
// The default constructor
//
Hanoi::Hanoi(): NumberPegs(3),NumberDiscs(3)
{
    Peg=new int*[NumberPegs];
    PegCount=new int[NumberPegs];
    for(int i=0;i<NumberPegs;i++) 
    {
       Peg[i]=new int[NumberDiscs];
       if(i==0) 
       {
          PegCount[i]=NumberDiscs;
          for(int j=0;j<NumberDiscs;j++)
             Peg[i][j]=NumberDiscs-j;
       }
       else
       {
          PegCount[i]=0;
           for(int j=0;j<NumberDiscs;j++)
              Peg[i][j]=0;
       }
    }
}
//-------------------------------------------------------------------
// A constructor
//
Hanoi::Hanoi(int discs,int pegs) 
{
    NumberPegs=pegs;
    NumberDiscs=discs;
    Peg=new int*[NumberPegs];
    PegCount=new int[NumberPegs];
    for(int i=0;i<NumberPegs;i++) 
    {
       Peg[i]=new int[NumberDiscs];
       if(i==0) 
       {
          PegCount[i]=NumberDiscs;
          for(int j=0;j<NumberDiscs;j++)
             Peg[i][j]=NumberDiscs-j;
       }
       else
       {
          PegCount[i]=0;
           for(int j=0;j<NumberDiscs;j++)
              Peg[i][j]=0;
       }
    }
}
//-------------------------------------------------------------------
// The copy constructor
//
Hanoi::Hanoi(const Hanoi& Right) {
    NumberPegs=Right.NumberPegs;
    NumberDiscs=Right.NumberDiscs;
    Peg=new int*[NumberPegs];
    PegCount=new int[NumberPegs];
    for(int i=0;i<NumberPegs;i++) 
    {
       Peg[i]=new int[NumberDiscs];
       PegCount[i]=Right.PegCount[i];
       for(int j=0;j<NumberDiscs;j++)
          Peg[i][j]=Right.Peg[i][j];
    }
}
//-------------------------------------------------------------------
Hanoi::~Hanoi() 
{
    if(PegCount!=NULL) 
    {
       delete []PegCount;
       for(int i=0;i<NumberPegs;i++)
          if(Peg[i]!=NULL)
            delete []Peg[i];   
       if(Peg!=NULL)
         delete []Peg;
    }
}
//-------------------------------------------------------------------
void Hanoi::operator =(const Hanoi &H) 
{
    if(NumberPegs!=H.NumberPegs || NumberDiscs!=H.NumberDiscs) 
    {
        if(PegCount!=NULL) 
        {
           delete []PegCount;
           for(int i=0;i<NumberPegs;i++)
              if(Peg[i]!=NULL)
                delete []Peg[i];   
           if(Peg!=NULL)
             delete []Peg;
        }
    PegCount=new int[H.NumberPegs];
    Peg=new int*[H.NumberPegs];
    for(int i=0;i<H.NumberPegs;i++) 
       Peg[i]=new int[H.NumberDiscs];
    }
    NumberPegs=H.NumberPegs;
    NumberDiscs=H.NumberDiscs;
    for(int i=0;i<NumberPegs;i++) 
    {
       PegCount[i]=H.PegCount[i];
       for(int j=0;j<NumberDiscs;j++)
          Peg[i][j]=H.Peg[i][j];
    }
}
//-------------------------------------------------------------------
int Hanoi::Move_Disc(int i,int j) {
    if(i>=0 && i<NumberPegs && j>=0 && j<NumberPegs && i!=j && PegCount[i]>0 && 
       (PegCount[j]==0 || Peg[i][PegCount[i]-1]<Peg[j][PegCount[j]-1]) )
    {
       Peg[j][PegCount[j]]=Peg[i][PegCount[i]-1];
       Peg[i][PegCount[i]-1]=0;
       PegCount[j]++;
       PegCount[i]--;
       return 1;
    }
    else
       return 0;
}
//-------------------------------------------------------------------
void Hanoi::Show_Towers() {
     cout<<"\n\n\n";
     for(int i=NumberDiscs-1;i>=0;i--)  {
        for(int j=0;j<NumberPegs;j++) {
              cout.width(6);
              if(Peg[j][i]!=0)
                 cout<<Peg[j][i];
              else
                 cout<<"|";
              }
        cout<<"\n";
        }
   cout<<"    _A_   _B_   _C_ \n\n";
   cout<<"Press enter to continue.";
   char a;
   cin.get(a);
   }
//-------------------------------------------------------------------
