// hanoi.h
// Written by Chuck Cusack, August 2000
//
// A class to store the Towers of Hanoi puzzle.
//
//-----------------------------------------------------------------------------
#include <iostream>
using namespace std;
//-----------------------------------------------------------------------------
// This stores the classic peg and disc game Towers of Hanoi.
// See almost any textbook discussing recursion for explaination of the puzzle.
//
class Hanoi {
public:
   //-------------------------------------------------------------------------
   // The constructors.
   // Create a Towers of Hanoi puzzle with pegs pegs and discs discs.
   // Precondition : discs and pegs are positive integers.
   // Postcondition: A towers of Hanoi puzzle is created with pegs pegs
   //  and discs discs.  Specifically, number_discs is set to discs, 
   //  number_pegs is set to pegs, peg is a number_pegs by number_discs 
   //  array of type int such that the first row has discs 1 through 
   //  number_discs in reverse order, (So the larger discs are below smaller
   //  discs), the rest have no discs, peg_count[0]=number_discs, 
   //  and peg_count[i]=0 for i=1,2,...number_pegs-1.
   //  
   //  The default constructor sets number_pegs to 3, number_discs to 1, 
   //  ans the other variables appropriately.
   //
   Hanoi();
   Hanoi(int discs,int pegs);

   //-------------------------------------------------------------------------
   // The Copy Constructor.
   //
   // Consider the following series of instructions:
   //
   // Hanoi Blah(4,3);
   // Hanoi Foo(Blah);
   //
   // Here, we wish to create Blah, then create Foo to be the same as Blah.
   // The copy constructor is called in this case.
   // There are MANY other times when it is called, and if it is not defined,
   // subtle errors will create havoc in your programs.
   //
   Hanoi(const Hanoi& H);

   //-------------------------------------------------------------------------
   // Put the toys away (Deallocate memory.)
   // We need to do this to prevent "memory leaks"
   //
   ~Hanoi();

   //-------------------------------------------------------------------------
   // The overloaded Assigment operator (=)
   // If A and B are objects of type Hanoi,
   // this defines the operation A=B.
   // If the assignment operator is not defined, unpredictable things
   // can happen.
   //
   void operator =(const Hanoi &H);

   //-------------------------------------------------------------------------
   // Move the top disc on peg i to peg j.
   // Precondition : i and j are different integers between 0 and number_pegs
   //                the top disc on peg i is smaller than the top disc on 
   //                peg j.
   //                Actually, no peg should have a larger disc on a 
   //                smaller one.  This is not checked.  However, with the
   //                operations defined, this can't ever happen.
   // Postcondition: The top disc from peg i is moved to the top of peg j.
   //     The return value is set to 1 if the operation is successful, or
   //     0 otherwise (i=j, big disc on small disc,...).
   //
   int Move_Disc(int i,int j);

   //-------------------------------------------------------------------------
   // Show what the current state of the towers is.
   // Precondition : The towers exist.
   // Postcondition: The towers are unchanged, and some output has
   //    been generated showing the current state.
   //
   void Show_Towers();

private:
   int NumberPegs;  // The number of pegs.
   int NumberDiscs; // The number of discs.
   int **Peg;        // The array to store the conents of each peg.
   int *PegCount;   // The array to store the number of discs on each peg.
};
