// solvehanoi.cc
//
// Charles A. Cusack, August 2000
//
// Show the solution to the Towers of Hanoi puzzle 
// with three towers given N discs.
// Usage:
// solvehanoi N
//
//-------------------------------------------------------------------------
#include "hanoi.h"
//-------------------------------------------------------------------------
void Solve_Hanoi(Hanoi &T,int N,int source,int destination,int spare);
//-------------------------------------------------------------------------
int main (int argc,char* argv[]) {

if(argc!=2 ) {       // Check for correct number of command line arguments
    cout<<"USAGE: "<<argv[0]<<" number\n"; 
    exit(1); 
    }
int n=atoi(argv[1]);        // Convert input to int

Hanoi Tower(n,3);           // Get the puzzle in it's start state

Tower.Show_Towers();        // Show the initial state

Solve_Hanoi(Tower,n,0,1,2); // Solve the puzzle

return 0;
}
//-------------------------------------------------------------------------
void Solve_Hanoi(Hanoi &T,int N,int source,int destination,int spare) {
    if(N==1) 
    {
      T.Move_Disc(source,destination);
      T.Show_Towers();
    }
    else
    {
       Solve_Hanoi(T,N-1,source,spare,destination);
       Solve_Hanoi(T,1,source,destination,spare);
       Solve_Hanoi(T,N-1,spare,destination,source);
    }
}
//-------------------------------------------------------------------------
