// Queens class implementation
//
//---------------------------------------------------------------------------
#include "queens.h"
//---------------------------------------------------------------------------
Queens::Queens()
{
     BoardSize=8;
     Board=NULL;
     NewBoard(BoardSize);    
     ClearBoard();
}
//---------------------------------------------------------------------------
Queens::Queens(int n)
{
     BoardSize=n;
     Board=NULL;
     NewBoard(BoardSize);    
     ClearBoard();
}
//---------------------------------------------------------------------------
Queens::~Queens()
{
    DeleteBoard();
}
//---------------------------------------------------------------------------
Queens::Queens(const Queens &Q)
{
    Board=NULL;
    CopyBoard(Q);
}
//---------------------------------------------------------------------------
Queens& Queens::operator=(const Queens& Q)
{
    if(this!=&Q)
    {
       DeleteBoard();
       CopyBoard(Q);
    }
    return *this;
}
//---------------------------------------------------------------------------
void Queens::CopyBoard(const Queens &Q)
{
     DeleteBoard();
     BoardSize=Q.BoardSize;
     NewBoard(BoardSize);
     for(int i=0;i<BoardSize;i++)
        for(int j=0;j<BoardSize;j++)
           Board[i][j]=Q.Board[i][j];  
}
//---------------------------------------------------------------------------
void Queens::NewBoard(int n)
{
     DeleteBoard();  
     BoardSize=n;
     Board=new square*[BoardSize];
     for(int i=0;i<BoardSize;i++)
        Board[i]=new square[BoardSize];
}
//---------------------------------------------------------------------------
void Queens::DeleteBoard()
{
    if(Board!=NULL) 
    {
         for(int i=0;i<BoardSize;i++)
            if(Board[i]!=NULL)  delete []Board[i];
         delete []Board;
         Board=NULL;
         BoardSize=0;
    }
}
//---------------------------------------------------------------------------
void Queens::ClearBoard()
{
     for(int i=0;i<BoardSize;i++)
        for(int j=0;j<BoardSize;j++)
           Board[i][j]=empty;
}
//---------------------------------------------------------------------------
void Queens::SetQueen(int Row,int Column)
{
     Board[Row][Column]=queen;
}
//---------------------------------------------------------------------------
void Queens::RemoveQueen(int Row,int Column)
{
     Board[Row][Column]=empty;
}
//---------------------------------------------------------------------------
bool Queens::IsUnderAttack(int Row,int Column)
{
    if(Row<0 || Row>=BoardSize || Column<0 || Column>=BoardSize)
      return false;
    for(int i=0;i<Column;i++)
       if(Board[Row][i]==queen)  
            return true;
    int i=1;
    while(Row-i>=0 && Column-i>=0)
    {
         if(Board[Row-i][Column-i]==queen) 
               return true;
         i++;
    }
    i=1;
    while(Row+i<BoardSize && Column-i>=0)
    {
         if(Board[Row+i][Column-i]==queen) 
                return true;
         i++;
    }
    return false;
}
//---------------------------------------------------------------------------
int Queens::PlaceQueens(int Column)
{
if(Column<BoardSize) 
{
   int Row = 0;
   while ( Row < BoardSize )                               // Try every row
   {
      if(!IsUnderAttack(Row,Column))     // If the spot is not under attack
      {
          SetQueen(Row,Column);                     // Place queen on board
          if (PlaceQueens(Column+1)) // Continue placing in the next column
          { 
                return true;           // If it was successful, return true
          }  
          else
          {                       // If no queen is possible in next column
             RemoveQueen(Row, Column);       // remove queen placed earlier
             Row++;                            // try next square in column
          }  
      } 
      else
      {
         Row++;          // If square can be attacked consider next square 
      }
   } 
   return false;
} 
else
{
   return true;
}
}  
//---------------------------------------------------------------------------
void PrintLine(int n)
{
  cout<<"|";
  for(int i=0;i<4*n-1;i++) 
     cout<<"-";
  cout<<"|\n";
  }
//---------------------------------------------------------------------------
void Queens::DisplayBoard()
{
  PrintLine(BoardSize);
  for(int i=0;i<BoardSize;i++)
{
      cout<<"|";
      for(int j=0;j<BoardSize;j++)
{
         if(Board[i][j]==empty)
{
            cout<<"   |";
          }
         else {
            cout<<" Q |";
          } 
       }
      cout<<"\n";
      PrintLine(BoardSize);
    }
   cout<<"\n";
 }
//---------------------------------------------------------------------------
