//-----------------------------------------------------------------
// Queens Class.
// A class that helps solve the non-attacking queens problem.
//
//-----------------------------------------------------------------
// Taken from "Data Abstraction and Problem Solving with C++:
//    Walls and Mirrors", 2nd Ed., by Carrano, Helman, and Veroff.
// Significant changes by Charles Cusack, Oct 2000.
//-----------------------------------------------------------------
//
#include <cstdlib>
#include <iostream>
using namespace std;

class Queens
{
public:
   Queens();      // Creates an empty square board of size 8.
   Queens(int n); // Creates an empty square board of size n.
   ~Queens();
   
   Queens(const Queens &Q);            // Copy Constructor
   Queens& operator=(const Queens &Q); // Assignment operator.

   void NewBoard(int n);      
   // Get a new board of size n by n.
   // Only allocates memory--values
   // are not guaranteed.

   void ClearBoard();         
   // Sets all squares to 'empty'.

   void DisplayBoard();       
   // Displays the board.

   int PlaceQueens(int Column);
   // ------------------------------------------------------
   // Places queens in columns of the board beginning at the
   // column numbered Column.
   // Precondition: Queens are placed correctly in columns 
   // 1 through Column-1.
   // Postcondition: If a solution is found, each column of 
   // the board contains one queen, and it returns 1.
   // otherwise, it returns 0.
   // ------------------------------------------------------

private:
   enum square {empty,queen};  // The two types of squares.
   int BoardSize;              // The size of the board.
   square **Board;             // The board.

   void CopyBoard(const Queens &Q); 
   // Copies Q to the current object.
   // Used by the copy constructor and assign operator.

   void DeleteBoard();        
   // Deallocates the memory used for the board.

   void SetQueen(int Row, int Column);
   // Sets the square on the board in a given row and column
   // to QUEEN.

   void RemoveQueen(int Row, int Column);
   // Sets the square on the board in a given row and column 
   // to EMPTY.

   bool IsUnderAttack(int Row, int Column);
   // Determines whether the square on the board at a given 
   // row and column is under attack by any queens in the 
   // columns 1 through Column-1.
   // Precondition: Each column between 1 and Column-1 has a 
   // queen placed in a square at a specific row. None of 
   // these queens can be attacked by any other queen.
   // Postcondition: If the designated square is under 
   // attack, returns true; otherwise, returns false.
};
