
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Timer;
import javax.swing.JPanel;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * The Animator class stores a list of MovingGraqphicalObjects.
 * It moves every object on the list once every time the timer
 * goes of, removing the objects from the list that are done
 * moving.
 * The same GraphicalObject may be contained in multiple 
 * MovingGraphicalObjects, and we make no attempt to worry about this.
 * Thus, if an object is moved up and then right for 100 units in
 * intervals of 10, then the object will move up and right and up and
 * right, etc. until each of these moves is done.  This allows one
 * to simulate arbitrary movement by issuing multiple moves on the
 * same object.
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2005
 */
public class Animator implements ActionListener
{
   JPanel myPanel; // The panel which the GraphicalObjects are on.
    // This is needed so that when the moves are done, a repaint can
    // be issued.  Note that if some or all of them are not on this
    // panel, no animation will occur, but that isn't our problem.
   
   // An ArrayList that can only store MovingGraphicalObjects
    ArrayList<MovingDrawableObject> theList;
    
    // The timer that will allow us to animate.
    Timer timer;
    
	/**
	 * Constructor for objects of class Animator
	 */
	public Animator(JPanel panel)
	{
	    myPanel = panel;
	    
	    // Constructing the ArrayList in such a way that it can only
	    // contain MovingGraphicalObjects
	    theList = new ArrayList<MovingDrawableObject>();
	    // Start the timer so it goes of 10 times per second and
	    // make this object the ActionListener.
	    timer = new Timer(100,this);
	}
    public void addObject(MovingDrawableObject mgo) {
        theList.add(mgo);
        // If the list has size 1 now, it was empty so we stopped
        // the timer.  Now we need to restart it.
        if(theList.size()==1) {
          timer.start();
        }
    }
    private void moveObjects() {
        // Get an iterator that iterates over a list that contains
        // only MovingGraphicalObjects.
        Iterator<MovingDrawableObject> iter=theList.iterator();
        
        // Move all of the objects.
        while(iter.hasNext()) {
            MovingDrawableObject mgo=iter.next();
            // Move the object.  If the move fails, it is done moving,
            // so remove it from the list.
            if(!mgo.move()) {
               iter.remove();
            }
        }
        // If the list is empty, stop the timer.
        if(theList.size()==0) {
            timer.stop();
        }
    }
    
    public void actionPerformed(ActionEvent e) {
        // We need to move all of the objects and repaint the
        // panel so the moves show up.
        moveObjects();
        myPanel.repaint();
    }
}
