import java.awt.*;

/**
 * BasicString.java
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2006
 */
public class BasicString extends DrawableObject
{
	private String myString; 
  
	public BasicString(int x, int y,Color color, String myString) {
		super(x,y,color);
	    setString(myString);
	}
	
	/*
	 * The standard get and set methods
	 */
    public void setString(String s) {
	   myString=s;
	}
    
	public String getString() {
	   return myString;
	}
	/**
	 * Overriding drawObject from GraphicalObject so it actually
	 * draws something.
	 */	
	@Override
	public void drawObject(Graphics g) {
	    // Save the current color so we can reset it when we are done
	    Color oldColor=g.getColor();
	    
	    g.setColor(this.getColor());
	    g.drawString(getString(),x,y);
	    // Reset the color back to the original.
	    g.setColor(oldColor);
	}
}
