/**
 * DrawableObject.java
 * Represents on object which can be drawn relative to its upper left corner.
 * 
 * @author Chuck Cusack
 * @version January 2009
 */

import java.awt.Color;
import java.awt.Graphics;

public abstract class DrawableObject {

	protected int x;
	protected int y;
	private Color color;

	/**
	 * Constructor
	 * @param x the x-coordinate of the upper left corner
	 * @param y the y-coordinate of the upper left corner
	 * @param color the color of the object
	 */
	public DrawableObject(int x, int y, Color color) {
		this.x = x;
		this.y = y;
		this.color = color;
	}

	public void setColor(Color color) {
	   this.color=color;
	}

	public Color getColor() {
	   return color;
	}

	public int getX() {
	    return x;
	}

	public void setX(int x) {
		   this.x=x;   
	}

	public int getY() {
	    return y;
	}

	public void setY(int y) {
	   this.y=y;   
	}

	public void setLocation(int x, int y) {
	    setX(x);
	    setY(y);
	}
	public void moveUp(int distance) {
	    y -= distance;
	}  
	public void moveDown(int distance) {
	    y += distance;
	}  
	public void moveRight(int distance) {
	    x += distance;
	} 
	public void moveLeft(int distance) {
	    x -= distance;
	}

	public abstract void drawObject(Graphics g);
	
	/**
	 * Draw the highlight around the object.
	 * This should be called BEFORE drawing the object
	 * so it appears behind it.
	 * @param g The Graphics context to draw on
	 */
	public void drawHighlight(Graphics g) {
        Color oldColor=g.getColor();
        g.setColor(Color.yellow);
        int x=getX()-2;
        int y=getY()-2;
        int width=10;  // BasicStrings do not have width and height
        int height=10; // I think 10 is about right....
        g.fillRect(x,y,width,height);  
        // Reset the color back to the original.
        g.setColor(oldColor);
	}

}