/**
 * DrawingStuff
 * The main class for the drawing program
 * 
 * This is an application that allows the user to move objects around the
 * screen to create drawings.  It is a "rough draft", so objects cannot
 * be added via the user interface.  For testing purposes, several objects
 * are added in the addStuff() method.
 * 
 * Right now, it supports 3 object types: Ovals, Rectangles, and Strings.
 * It would be nice if I could add triangles, Polygons, Lines, JPEG images, 
 * etc.
 * 
 * Your job is to get started on this by adding triangles and lines.
 * You may refactor the code and add as many new classes as you need to.
 * Of course, design is of utmost importance, so make wise and informed
 * decisions about your class structure.
 * 
 * You should probably not need to modify this class--well except to
 * add a few of the new types of objects.
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2006
 * Modified January, 2009
 */
import javax.swing.*;
import java.awt.*;

public class DrawingStuff extends JApplet {
    
    // The desired dimensions of the main window
    public final static int width=450;
    public final static int height=400;
    
    // The graphical components
    private DrawingPanel mainPanel;
    
    /**
     * The main method, which allows us to run the application from
     * anywhere.  
     */
    public static void main(String[] args) {  
        
        JFrame theFrame = new JFrame();
        theFrame.setTitle("A Drawing Example");
        
        DrawingStuff df = new DrawingStuff();
        
        // Place all of the graphical components on the main window
        Container cont=theFrame.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add(df.mainPanel,BorderLayout.CENTER);
        
        // Finish setting up the main window
        theFrame.setBackground(Color.white);
        theFrame.pack(); 
        theFrame.setSize(new Dimension(width,height));
        theFrame.setVisible(true);
     }
    
       public void init() {
        
        mainPanel=new DrawingPanel();
        addStuff();
        
        // Place all of the graphical components on the main window
        Container cont=getContentPane();
        cont.add(mainPanel);
        
        // Finish setting up the main window
        setBackground(Color.white);
        setVisible(true);
    }
    
    /**
     * The default constructor.
     * It creates the drawing panel and various other components
     * that we need for our program.
     */
    public DrawingStuff() {
        mainPanel=new DrawingPanel();
        addStuff();
    }
    
    /**
     * The addStuff method is for testing the class.  It creates
     * various objects of various types in various ways to help us
     * test our code.
     */
    public void addStuff() {
		mainPanel.addObject(new Oval(10,10,Color.green,100,150,false));
		mainPanel.addObject(new Oval(100,200,Color.green,75,75,true));
		
		Rectangle rect=new Rectangle(200,150,Color.blue,200,150,true);
		mainPanel.addObject(rect);
		mainPanel.setSelectedObject(rect);
        mainPanel.addObject(new BasicString(250,20,Color.blue,"Hello"));
        int[]x={50,150,200};
        int []y = {200,100,150};
        mainPanel.addObject(new Triangle(x,y,Color.red,true));
        
    }  
}

