
/**
 * The class MovingGraphicalObject describes a GraphicalObject and desired move.  
 * The constructor takes an object as well as the direction and distance to
 * travel, and how much gto travel each step of the way.
 * None of these can be changed by the outside world.
 * The move method will move the object in the desired direction interval
 * steps, until the object has moved distance or more steps.  
 * The move method does not check that distance is an exact multiple of
 * interval, so the movement may be a bit more than distance...
 * 
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2005
 */
public class MovingDrawableObject
{
	DrawableObject theObject;
	int direction;
	int distance;
	int interval;

	public static final int UP = 0;
	public static final int DOWN = 1;
	public static final int RIGHT = 2;
	public static final int LEFT = 3;
	/**
	 * Constructor for objects of class MovingGraphicalObject
	 */
	public MovingDrawableObject(DrawableObject go, int dir, int dist, int inter)
	{
		theObject=go;
		direction=dir;
		distance=dist;
		interval=inter;
	}
	
	public DrawableObject getObject() {
	    return theObject;
	}
	
	public boolean isDoneMoving() {
	    return (distance<=0);
	}
	
	public boolean move() {
	    if(!isDoneMoving()) {
	        switch(direction) {
	        case UP:
	            theObject.moveUp(interval);
	            break;
	        case DOWN:
	            theObject.moveDown(interval);
	            break;
	         case RIGHT:
	            theObject.moveRight(interval);
	            break;
	         case LEFT:
	            theObject.moveLeft(interval);
	            break;
	        }
	        distance -= interval;
	        return true;
	    }
	    else 
	    {
	       return false;
	     }
	}
}
