import java.awt.*;

/**
 * Oval.java
 * Stores an Oval object.
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2006
 */
public class Oval extends Shape
{   
    /**
     * The constructor that creates an object at (x,y) of size
     * width by height, of the given color, and filled or hollow
     * based on the value of isFilled
     */
	public Oval(int x, int y, Color color,int width, int height, boolean isFilled) {
	    super(x,y,color,width,height,isFilled);
	}
		
	/**
	 * The method to draw the oval if it is filled in.
	 */
	@Override
	protected void drawFilledShape(Graphics g) {
	    g.fillOval(x,y,width,height);
	}
	/**
	 * The method to draw the oval if it is not filled in.
	 */
	@Override
	protected void drawHollowShape(Graphics g) {
	    g.drawOval(x,y,width,height);
	}
}

