import java.awt.*;

/**
 * Rectangle.java
 * Stores a rectangle
 * @author Chuck Cusack
 * @version 1.0, September, 2006
 */
public class Rectangle extends Shape
{
    
    /**
     * The constructor that creates an object at (x,y) of size
     * width by height, of the given color, and filled or hollow
     * based on the value of isFilled
     */
	public Rectangle(int x, int y, Color color,int width, int height, boolean isFilled) {
	    super(x,y,color,width,height,isFilled);
	}
	
	/**
	 * The method to draw the rectangle if it is filled in.
	 */
	@Override
	protected void drawFilledShape(Graphics g) {
	    g.fillRect(x,y,width,height);
	}
	/**
	 * The method to draw the rectangle if it is not filled in.
	 */
	@Override
	protected void drawHollowShape(Graphics g) {
	    g.drawRect(x,y,width,height);
	}
}
