import java.awt.Color;
import java.awt.Graphics;

/**
 * Triangle.java
 * 
 * Stores a triangle.
 * 
 * @author Chuck Cusack
 * @version January 2009
 *
 */
public class Triangle extends Shape {

	//The minimum x and y are needed so the object can be moved properly.
	int minX;
	int minY;
	
	// The points of the triangle
	int xCoords[] = new int[3];
	int yCoords[] = new int[3];
	
	/**
	 * Construct the triangle based on the 3 points.
	 * The hardest part of the constructor is figuring out the x, y, width, 
	 * and height.  In addition, making it move aroun (changing x and y) 
	 * is a bit more troublesome.
	 * 
	 * @param coords the x coordinates of the 3 points
	 * @param coords2 the y coordinates of the 3 points
	 * @param color the color of the triangle
	 * @param isFilled whether or not to fill in the triangle.
	 */
	public Triangle(int[] coords, int[] coords2,Color color, boolean isFilled) {
		super();
	    setColor(color);
	    setFilled(isFilled);
		xCoords = coords;
		yCoords = coords2;
		x=xCoords[0];
		y=yCoords[0];
		int xBig = xCoords[0];
		int yBig = yCoords[0];
		for(int i=0;i<3;i++) {
			if(x>xCoords[i]) 
				x=xCoords[i];
			if(y>yCoords[i]) 
				y=yCoords[i];
			if(xBig<xCoords[i]) 
				xBig=xCoords[i];
			if(yBig<yCoords[i]) 
				yBig=yCoords[i];
		}
		minX=x;
		minY=y;
		width = xBig-x;
		height = yBig - y;
	}
	
	/**
	 * The method to draw the triangle if it is filled in.
	 * Notice that it has to translate to be drawn in the 
	 * correct spot.
	 */
	@Override
	protected void drawFilledShape(Graphics g) {
		g.translate(x-minX,y-minY);
	    g.fillPolygon(xCoords,yCoords,3);
		g.translate(-(x-minX),-(y-minY));
	}
	/**
	 * The method to draw the triangle if it is hollow.
	 * Notice that it has to translate to be drawn in the 
	 * correct spot.
	 * */
	@Override
	protected void drawHollowShape(Graphics g) {
		g.translate(x-minX,y-minY);
	    g.drawPolygon(xCoords,yCoords,3);
		g.translate(-(x-minX),-(y-minY));
	}


}
