/*
 * EfficientChristmasApplet.java
 *  THIS APPLET USES FOR! IT IS MORE EFFICIENT AND EASIER TO MANAGE!
 *  Written by Chuck's class and Matt Johnson
 *  Written on 9-16-02
 */

import javax.swing.*;

public class ChristmasApplet extends JApplet {

    //----------------------------------------------------------------------
    // attributes
   
                  // The words for 1st, 2nd, etc. in an array for easy access.
    public static final String theNumbers[] = { "first", "second", "third", 
                            "fourth", "fifth", "sixth", "seventh", "eighth",
                            "ninth", "tenth", "eleventh", "twelfth" };

                // The items from the 12 days of Christmas, stored in an array.
                // Since the first item changes slightly from day one to the
                // other days, we store it in both forms.  
    public static final String theMessages[] = { 
        "And a partridge in a pear tree.\n",
        "A partridge in a pear tree.\n",
        "Two turtle doves,\n",
        "Three French hens,\n",
        "Four calling birds,\n",
        "Five gold rings,\n",
        "Six geese a-laying,\n",
        "Seven swans a-swimming,\n",
        "Eight maids a-milking,\n",
        "Nine drummers drumming,\n",
        "Ten pipers piping,\n",
        "Eleven ladies dancing,\n",
        "Twelve lords a-leaping,\n" };

    //------------------------------------------------------------------------
    // Initialize the applet
    //
    public void init() {

        String the12Days = "";         // The text of the 12 days of Christmas
        for( int theDay = 1; theDay <= 12; theDay++ ) { // For day 1 to day 12
              the12Days += getTextForDay( theDay ); // Add text for that day
        }
        
               // Place the text on a JTextArea, which is then placed on a 
               // JScrollPane, which is then placed on the JOptionPane.
        JTextArea textArea = new JTextArea( the12Days, 20, 40 );
        textArea.setEditable( false );
        JScrollPane scrollArea = new JScrollPane( textArea );
        JOptionPane.showMessageDialog( null, scrollArea, 
                                       "Twelve Days of Christmas", 
                                       JOptionPane.INFORMATION_MESSAGE );
    }
    
    //------------------------------------------------------------------------
    // getTextForDay forms the text for day theDay and returns it as a String.
    //
    public String getTextForDay(int theDay) {

        String dayX = "";                               // The text for the day
                                                 // The first part of the verse
        dayX = "On the " + theNumbers[theDay - 1] + " day of Christmas," 
                +" my true love gave to me:\n";
        
                                                       // The items for the day
        for ( int countDay = theDay; countDay > 1; countDay-- ) {
            dayX += theMessages[countDay];
        }
        
                // Depending on whether it is day one or not, display a different
                // wording for day 1.
        if ( theDay == 1 ) {
            dayX += theMessages[1];
        } else {
            dayX += theMessages[0];
        }
        
        dayX += "\n";
        return dayX;                                        // return the text
    }
    //-------------------------------------------------------------------------
}
