/*
 * ChristmasApplet.java
 *  Written by Chuck's class and Matt Johnson
 *  Written on 9-16-02
 */

import javax.swing.*;

public class ChristmasAppletV2 extends JApplet {
    
    //----------------------------------------------------------------------
    // attributes
   
                  // The words for 1st, 2nd, etc. in an array for easy access.
    public static final String theNumbers[] = { "first", "second", "third", 
                            "fourth", "fifth", "sixth", "seventh", "eighth",
                            "ninth", "tenth", "eleventh", "twelfth" };



    //------------------------------------------------------------------------
    // Initialize the applet
    //
    public void init() {

        String the12Days = "";         // The text of the 12 days of Christmas
        for( int theDay = 1; theDay <= 12; theDay++ ) {  // For day 1 to day 12
              the12Days += getTextForDay( theDay );    // Add text for that day
        }
        
               // Place the text on a JTextArea, which is then placed on a 
               // JScrollPane, which is then placed on the JOptionPane.
        JTextArea textArea = new JTextArea( the12Days, 20, 40 );
        textArea.setEditable( false );
        JScrollPane scrollArea = new JScrollPane( textArea );
        JOptionPane.showMessageDialog( null, scrollArea, 
                                       "Twelve Days of Christmas", 
                                       JOptionPane.INFORMATION_MESSAGE );
    }
    //------------------------------------------------------------------------
    // getTextForDay forms the text for day theDay and returns it as a String.
    //
    public String getTextForDay(int theDay) {

        String dayX = "";                               // The text for the day
                                                 // The first part of the verse
        dayX = "On the " + theNumbers[theDay - 1] + " day of Christmas," 
                +" my true love gave to me:\n";
        
          // The items for the day are added, one at a time.  We use a switch
	  //  with no break statements, since for day x, we want the items for
	  //  day x-1, x-2, ..., 2, 1.
        switch (theDay) {
            case 12:
                dayX += "Twelve lords a-leaping,\n";
            case 11:
                dayX += "Eleven ladies dancing,\n";
            case 10:
                dayX += "Ten pipers piping,\n";   
            case 9:
                dayX += "Nine drummers drumming,\n";
            case 8:
                dayX += "Eight maids a-milking,\n";
            case 7:
                dayX += "Seven swans a-swimming,\n";
            case 6:
                dayX += "Six geese a-laying,\n";
            case 5:
                dayX += "Five gold rings,\n";
            case 4:
                dayX += "Four calling birds,\n";
            case 3:
                dayX += "Three French hens,\n";
            case 2:
                dayX += "Two turtle doves,\n";
            case 1:
                if ( theDay == 1 )  // For day 1, we need:
                    dayX += "A partridge in a pear tree.\n";
                else     // But for the other days, we want:
                    dayX += "And a partridge in a pear tree.\n";
            default:
        }
        
        dayX += "\n";
        return dayX;                                         // return the text
    }
}
