//----------------------------------------------------
// BowlingModel
// Written by Chuck Cusack, Jan 2002
// An implementation of the AbstractTableModel
// An example of how to write a model for use in a JTable.  
// This gets the data from a database, and uses the
// result set to form an array.
//----------------------------------------------------
import java.sql.*;
import javax.swing.*;
import javax.swing.table.*;
public class BowlingModel extends AbstractTableModel {
    //------------------------------------------------
    // We need to store the number of rows and columns
    int myRows;
    int myCols;
    ResultSet myRS=null;

    //------------------------------------------------
    // The first group of methods override methods
    // from the super class so that the model behaves
    // as we wish.
    //------------------------------------------------

    //------------------------------------------------
    // The constructor sets the table sizs to 3 x 3.
    //
    public BowlingModel() {
        myRows=0;
        myCols=0;
    }
    //------------------------------------------------
    // Obvious
    //
    public int getColumnCount() {
        return myCols;
    }
    //------------------------------------------------
    // Obvious
    //
    public int getRowCount() {
        return myRows;
    }
    //------------------------------------------------
    // We label the columns with the power it holds.
    //
    public String getColumnName(int i) {
        switch(i) {
          case 0:
            return "Name";
          case 1:
            return "Score";
          case 2:
            return "Game";
          case 3:
            return "Date";
          case 4:
            return "Tourney";
          default:
            return "Not a Column";
        }
    }
    //------------------------------------------------
    // Return the value for each cell. 
    // Table cell (row,col) should be (rows+1)^(col+1),
    // since the table represents the first 'col' 
    // powers of the first 'row' integers.  Since we 
    // start indexing at (0,0), we add one to each 
    // dimension.  
    // When the powers become too large, we say so.
    // Notice that we never actually store ANY data in
    // the table.
    //
    public Object getValueAt(int row,int col) {
      try {
          myRS.absolute(row+1);
          String S=myRS.getString(col+1);
          return S;
      } catch (SQLException e) {
        System.out.println(e.getMessage());
        return "SQL Error";
      }
    }

    //------------------------------------------------
    public void setResultSet(ResultSet rs) {
      try {
         myRS=rs;
         myRS.last();
         myRows=myRS.getRow();
System.out.println(myRows);
         myCols=5;
         fireTableStructureChanged();
      } catch (SQLException e) {}
    }
    //------------------------------------------------
}
