import java.awt.*;

/**
 * Write a description of class BasicShape here.
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2005
 */
public abstract class BasicShape extends SizedObject
{
    // Basic shape objects have a color and are either
    // hollow or filled.
    protected Color color;
    protected boolean isFilled;
 	
    /**
     * The defualt constructor, which creates a 0 by 0 object at (0,0)
     * that is white and not filled.
     */
    public BasicShape() {
        super();
        setColor(Color.white);
        setFilled(false);
    }  
    
    /**
     * The constructor that creates an object at (x,y) of size
     * width by height, of the given color, and filled or hollow
     * based on the value of isFilled
     */
	public BasicShape(int x, int y, int width, int height,
	                       Color color, boolean isFilled) {
	    super(x,y,width,height);
	    setColor(color);
	    setFilled(isFilled);
	}
		
	/*
	 * The standard get and set methods
	 */
	public void setFilled(boolean isFilled) {
	   this.isFilled=isFilled;
	}
	public boolean getFilled() {
	   return isFilled;
	}
	public void setColor(Color color) {
	   this.color=color;
	}
	public Color getColor() {
	   return color;
	}
   /**
	 * Overriding drawObject from GraphicalObject so it actually
	 * draws something.
	 */
	public void drawObject(Graphics g) {
	    // Save the current color so we can reset it when we are done
	    Color oldColor=g.getColor();
	    
	    g.setColor(this.getColor());
	    if(isFilled) {
	        drawFilledShape(g);
	    } else {
	        drawHollowShape(g);   
	    }
	    // Reset the color back to the original.
	    g.setColor(oldColor);
	}
	
	//-------------------------------------------------------------------
	// The methods to draw the shapes, based on whether they are filled
	// or not.  The changing of the color is taken care of already,
	// so these methods only need to draw the object.
	
	/**
	 * The method to draw the shape if it is filled in.
	 * Since we don't know the shape, we will just say what we are...
	 */
	protected abstract void drawFilledShape(Graphics g);
	/**
	 * The method to draw the shape if it is not filled in.
	 * Since we don't know the shape, we will just say what we are...
	 */
	protected abstract void drawHollowShape(Graphics g);
}
