import java.awt.*;
/**
 * Write a description of class BasicString here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class BasicString extends GraphicalObject
{
    // Basic Strings have a color.
    protected Color color;
    
    protected String myString;

	/**
	 * Constructor for objects of class BasicString
	 */
	public BasicString() {
		super();
		setColor(Color.black);
		setString("");
	}    
	/**
     * The constructor that creates an object at (x,y) of size
     * width by height, of the given color, with the given string.
     */
	public BasicString(int x, int y,Color color, String myString) {
	    super(x,y);
	    setColor(color);
	    setString(myString);
	}
	
    public void setString(String s) {
	   myString=s;
	}
	public String getString() {
	   return myString;
	}
	public void setColor(Color color) {
	   this.color=color;
	}
	public Color getColor() {
	   return color;
	}
	
	 /**
	 * Overriding drawObject from GraphicalObject so it actually
	 * draws something.
	 */
	public void drawObject(Graphics g) {
	    // Save the current color so we can reset it when we are done
	    Color oldColor=g.getColor();
	    
	    g.setColor(this.getColor());
	    g.drawString(getString(),x,y);
	    // Reset the color back to the original.
	    g.setColor(oldColor);
	}
}
