/**
 * DrawingExample
 * The main class for the drawing program
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2005
 */
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;

public class DrawingExample extends JApplet  {
    
    // The desired dimensions of the main window
    private int width=800;
    private int height=600;
    
    // The graphical components
    private DrawingPanel mainPanel;
 
    /**
     * The default constructor.
     * It creates the drawing panel and various other components
     * that we need for our program.
     */
    public void init() {
        
        // Instantiate the main drawing panel
        mainPanel=new DrawingPanel();
        
        // Place all of the graphical components on the main window
        Container cont=getContentPane();
        cont.add(mainPanel);
        
        // Finish setting up the main window
        setBackground(Color.white);
        setVisible(true);
        addStuff();
    }

    public void start() {
        mainPanel.requestFocusInWindow();
    }
    
    /**
     * The addStuff method is for testing the class.  It creates
     * various objects of various types in various ways to help us
     * test our code.
     */
    public void addStuff() {
		mainPanel.addObject(new Oval(10,10,100,150,Color.green,false));
		mainPanel.addObject(new Oval(100,200,200,150,Color.green,true));
		
		Rectangle rect=new Rectangle(100,150,250,150,Color.blue,true);
		mainPanel.addObject(rect);
		mainPanel.setSelectedObject(rect);
		
        BasicShape blah=(BasicShape) createObject("Rectangle");
        blah.setLocationAndSize(100,150,200,20);
        blah.setColor(Color.orange);
        blah.setFilled(true);
        mainPanel.addObject(blah);
       
        mainPanel.addObject(new BasicString(300,20,Color.blue,"Hello"));
    }
    /**
     * Creates and object based on the name of the class.
     * We will need this to allow us to create dynamic objects based
     * on a list of available objects.
     */
     private GraphicalObject createObject(String name) {
        GraphicalObject go=null;
        try {
          Class theClass  = Class.forName(name);
          go = (GraphicalObject)theClass.newInstance();
        }
        catch ( ClassNotFoundException ex ){
          System.err.println( ex + name + " class must be in class path.");
        }
        catch( InstantiationException ex ){
          System.err.println( ex + name + " class must be concrete.");
        }
        catch( IllegalAccessException ex ){
          System.err.println( ex + name + " class must have a no-arg constructor.");
        }
        return go;
  }
}

