import java.awt.*;

/**
 * A class that stores an object that is to be drawn on some canvas
 * somewhere.  Since the method can be called from anywhere, the object
 * can be draw in different places.
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2005
 */
public abstract class GraphicalObject {
	protected int x;
	protected int y;
	
	/**
	 * Default constructor--create a 0 by 0 object located at (0,0).
	 */
	public GraphicalObject() {
	    setLocation(0,0);
	}
	
	/**
	 * Constructor for objects of class GraphicalObject
	 * @param x the x-coordinate of the upper-left corner of the object
	 * @param y the y-ccordinate of the upper-left corner of object
	 */
	public GraphicalObject(int x,int y) {
		this.x=x;
		this.y=y;
		// Or: 
		// setLocation(x,y);
		// Or:
		// setX(x);
		// setY(y);
	}

	/**
	 * drawObject
	 * Draw the object on the given graphics object
	 * @param g the graphics context
	 */
	public abstract void drawObject(Graphics g);
	
	//----------------------------------------------------
	// The usual get methods
	
	public int getX() {
	    return x;
	}
	public int getY() {
	    return y;
	}
	
	// The usual set methods
	public void setLocation(int x,int y) {
	    setX(x);
	    setY(y);
	}
	public void setX(int x) {
	   this.x=x;   
	}
    public void setY(int y) {
	   this.y=y;   
	}   
}
