import java.awt.*;

/**
 * 
 * @author Chuck Cusack
 * @version 1.0, September, 2005
 */
public abstract class SizedObject extends GraphicalObject {
	protected int width;
	protected int height;
	
	/**
	 * Default constructor--create a 0 by 0 object located at (0,0).
	 */
	public SizedObject() {
	    setLocationAndSize(0,0,0,0);
	}
	
	/**
	 * Constructor for objects of class GraphicalObject
	 * @param x the x-coordinate of the upper-left corner of the object
	 * @param y the y-ccordinate of the upper-left corner of object
	 * @param width the width of the object
	 * @param height the height of the object
	 */
	public SizedObject(int x,int y,int width,int height) {
		setX(x);
		setY(y);
		this.width=width;
		this.height=height;
		// Or:
		// setLocationAndSize(x,y,width,height);
		// There are many other ways of implementing this method...
	}
	
	//----------------------------------------------------
	// The usual get methods

	public int getWidth() {
	    return width;
	   }
	public int getHeight() {
	    return height;
	}
	
	// The usual set methods    
	public void setWidth(int width) {
	   this.width=width;   
	}
    public void setHeight(int height) {
	   this.height=height;   
	}
	public void setLocationAndSize(int x,int y,int width,int height) {
	    setLocation(x,y);
	    setSize(width,height);
	}
	public void setSize(int width,int height) {
	    setWidth(width);
	    setHeight(height);
	}   
}
