import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * A class that demonstrates the relative speed of growth of various functions
 *
 * @author Cory Lueninghoener <cluening@cse.unl.edu>
 */
public class FunctionGrowth extends JApplet {
    boolean isLinked = false;
    boolean isStandalone = false;
    JSlider ySlider = new JSlider();
    BorderLayout borderLayout1 = new BorderLayout();
    JSlider xSlider = new JSlider();
    GraphPanel graphPanel = new GraphPanel();
    JPanel jPanel1 = new JPanel();
    JToggleButton linkButton = new JToggleButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JComboBox f1 = new JComboBox();
    JComboBox f2 = new JComboBox();
    JComboBox f3 = new JComboBox();
    JTextField f1Const = new JTextField();
    JTextField f2Const = new JTextField();
    JTextField f3Const = new JTextField();
    JLabel xLabel1 = new JLabel();
    JLabel xLabel2 = new JLabel();
    JLabel xLabel3 = new JLabel();
    /**Get a parameter value*/
    public String getParameter(String key, String def) {
	return isStandalone ? System.getProperty(key, def) :
	    (getParameter(key) != null ? getParameter(key) : def);
    }
    
    /**Construct the applet*/
    public FunctionGrowth() {
    }
    /**Initialize the applet*/
    public void init() {
	f1.addItem("1");
	f1.addItem("n^.1");
	f1.addItem("log(n)");
	f1.addItem("sqrt(n)");
	f1.addItem("n");
	f1.addItem("nlog(n)");
	f1.addItem("n^2");
	f1.addItem("n^3");
	f1.addItem("n^4");
	f1.addItem("2^n");
	f1.addItem("3^n");
	f1.addItem("n!");
	f1.setSelectedIndex(graphPanel.getCurGraph(1));
	
	f2.addItem("1");
	f2.addItem("n^.1");
	f2.addItem("log(n)");
	f2.addItem("sqrt(n)");
	f2.addItem("n");
	f2.addItem("nlog(n)");
	f2.addItem("n^2");
	f2.addItem("n^3");
	f2.addItem("n^4");
	f2.addItem("2^n");
	f2.addItem("3^n");
	f2.addItem("n!");
	f2.setSelectedIndex(graphPanel.getCurGraph(2));
	
	f3.addItem("1");
	f3.addItem("n^.1");
	f3.addItem("log(n)");
	f3.addItem("sqrt(n)");
	f3.addItem("n");
	f3.addItem("nlog(n)");
	f3.addItem("n^2");
	f3.addItem("n^3");
	f3.addItem("n^4");
	f3.addItem("2^n");
	f3.addItem("3^n");
	f3.addItem("n!");
	f3.setSelectedIndex(graphPanel.getCurGraph(3));
	
	try {
	    jbInit();
	}
	catch(Exception e) {
	    e.printStackTrace();
	}
    }
    /**Component initialization*/
    private void jbInit() throws Exception {
	this.setSize(new Dimension(523, 300));
	this.getContentPane().setLayout(borderLayout1);
	ySlider.setMinorTickSpacing(1);
	ySlider.setMajorTickSpacing(10);
	ySlider.setOrientation(JSlider.VERTICAL);
	ySlider.setMinimum(1);
	ySlider.setValue(graphPanel.getYMax());
	ySlider.setMaximum(60);
	ySlider.addChangeListener(new javax.swing.event.ChangeListener() {
		public void stateChanged(ChangeEvent e) {
		    ySlider_stateChanged(e);
		}
	    });
	xSlider.setMinorTickSpacing(1);
	xSlider.setMajorTickSpacing(10);
	xSlider.setMinimum(1);
	xSlider.setValue(graphPanel.getXMax());
	xSlider.setMaximum(60);
	xSlider.addChangeListener(new javax.swing.event.ChangeListener() {
		public void stateChanged(ChangeEvent e) {
		    xSlider_stateChanged(e);
		}
	    });
	graphPanel.setBorder(BorderFactory.createLoweredBevelBorder());
	linkButton.setText("Link");
	linkButton.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    linkButton_actionPerformed(e);
		}
	    });
	jPanel1.setLayout(borderLayout2);
	f1.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    f1_actionPerformed(e);
		}
	    });
	f2.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    f2_actionPerformed(e);
		}
	    });
	f3.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    f3_actionPerformed(e);
		}
	    });
	f1.setForeground(Color.red);
	f2.setForeground(new Color(0, 200, 0));
	f3.setForeground(Color.blue);
	f1Const.setMinimumSize(new Dimension(30, 19));
	f1Const.setPreferredSize(new Dimension(30, 19));
	f1Const.setText("1");
	f1Const.setHorizontalAlignment(SwingConstants.TRAILING);
	f1Const.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    f1Const_actionPerformed(e);
		}
	    });
	f2Const.setMinimumSize(new Dimension(30, 19));
	f2Const.setPreferredSize(new Dimension(30, 19));
	f2Const.setText("1");
	f2Const.setHorizontalAlignment(SwingConstants.TRAILING);
	f2Const.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    f2Const_actionPerformed(e);
		}
	    });
	f3Const.setMinimumSize(new Dimension(30, 19));
	f3Const.setPreferredSize(new Dimension(30, 19));
	f3Const.setText("1");
	f3Const.setHorizontalAlignment(SwingConstants.TRAILING);
	f3Const.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    f3Const_actionPerformed(e);
		}
	    });
	xLabel1.setText("X");
	xLabel2.setText("X");
	xLabel3.setText("X");
	this.getContentPane().add(graphPanel, BorderLayout.CENTER);
	this.getContentPane().add(ySlider, BorderLayout.WEST);
	this.getContentPane().add(jPanel1, BorderLayout.SOUTH);
	jPanel1.add(linkButton, BorderLayout.WEST);
	jPanel1.add(xSlider, BorderLayout.CENTER);
	this.getContentPane().add(jPanel2, BorderLayout.NORTH);
	jPanel2.add(f1Const, null);
	jPanel2.add(xLabel1, null);
	jPanel2.add(f1, null);
	jPanel2.add(f2Const, null);
	jPanel2.add(xLabel2, null);
	jPanel2.add(f2, null);
	jPanel2.add(f3Const, null);
	jPanel2.add(xLabel3, null);
	jPanel2.add(f3, null);
    }
    /**Get Applet information*/
    public String getAppletInfo() {
	return "Applet Information";
    }
    /**Get parameter info*/
    public String[][] getParameterInfo() {
	return null;
    }
    
    //static initializer for setting look & feel
    static {
	try {
	    //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
	}
	catch(Exception e) {
	}
    }
    
    private void xSlider_stateChanged(ChangeEvent e) {
	int n = xSlider.getValue();
	int newvalue = (int)Math.pow(10, n/10)*(1+n%10);
	
	//System.out.println("X changed :" + newvalue);
	graphPanel.setXMax(newvalue);
	graphPanel.setXVal(n);
	if(isLinked){
	    ySlider.setValue(n);
	    graphPanel.setYMax(newvalue);
	}
	graphPanel.repaint();
    }
    
    private void ySlider_stateChanged(ChangeEvent e) {
	int n = ySlider.getValue();
	int newvalue = (int)Math.pow(10, n/10)*(1+n%10);
	
	//System.out.println("Y changed :" + newvalue);
	graphPanel.setYMax(newvalue);
	graphPanel.setYVal(n);
	if(isLinked){
	    xSlider.setValue(n);
	    graphPanel.setXMax(newvalue);
	}
	graphPanel.repaint();
    }
    
    private void linkButton_actionPerformed(ActionEvent e) {
	if(isLinked == false){
	    isLinked = true;
	    ySlider.setValue(xSlider.getValue());
	    graphPanel.setYMax(xSlider.getValue());
	} else {
	    isLinked = false;
	}
    }
    
    private void f1_actionPerformed(ActionEvent e) {
	System.out.println(f1.getSelectedIndex());
	graphPanel.setCurGraph(1, f1.getSelectedIndex());
	graphPanel.repaint();
    }
    
    private void f2_actionPerformed(ActionEvent e) {
	System.out.println(f2.getSelectedIndex());
	graphPanel.setCurGraph(2, f2.getSelectedIndex());
	graphPanel.repaint();
    }
    
    private void f3_actionPerformed(ActionEvent e) {
	System.out.println(f3.getSelectedIndex());
	graphPanel.setCurGraph(3, f3.getSelectedIndex());
	graphPanel.repaint();
    }
    
    private void f1Const_actionPerformed(ActionEvent e) {	
	int newval = 0;
	
	try{
	    newval = Integer.parseInt(f1Const.getText());
	}
	catch(Exception except){
	    newval = 1;
	    f1Const.setText("1");
	}
	finally{};

	if(newval > 0){
	    graphPanel.setCurConst(1, newval);
	}
	else{
	    f1Const.setText("1");
	    graphPanel.setCurConst(1, 1);
	}
	graphPanel.repaint();
    }
    
    private void f2Const_actionPerformed(ActionEvent e) {
	graphPanel.setCurConst(2, Integer.parseInt(f2Const.getText()));
	graphPanel.repaint();
    }
    
    private void f3Const_actionPerformed(ActionEvent e) {
	graphPanel.setCurConst(3, Integer.parseInt(f3Const.getText()));
	graphPanel.repaint();
    }
}
