import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.applet.*;
import javax.swing.*;
/**
 * A panel that draws a number of graphs.
 * @author Cory Lueninghoener
 */

public class GraphPanel extends JPanel {
    // When adding functions, use the same numbers as their order in the combobox
    public static final int 
        ONE = 0,
        N_POINT_ONE = 1, 
        LOG_N = 2, 
        SQRT_N = 3,
        N = 4,
        N_LOG_N = 5,  
        N_SQUARED = 6,
        N_CUBED = 7,    
        N_FOURTH = 8,   
        TWO_POW_N = 9,   
        THREE_POW_N = 10,
        N_FACTORIAL = 11;

    
    //public static final int ONE = 0, N = 1, N_SQUARED = 2, N_CUBED = 3, LOG_N = 4, N_LOG_N = 5, TWO_POW_N = 6, N_FACTORIAL = 7;
    
    private int curGraph1 = ONE;
    private int curGraph2 = N;
    private int curGraph3 = N_SQUARED;
    private int const1 = 1;
    private int const2 = 1;
    private int const3 = 1;
    private int xMax = 5;
    private int yMax = 5;
    private int xVal = 5;
    private int yVal = 5;
    
    /**
     * Creates a new GraphPanel object
     */
    public GraphPanel() {
	System.out.println("Creating GraphPanel");
	try {
	    jbInit();
    }
	catch(Exception e) {
	    //e.printStackTrace();
	}
	
    }
    
    /**
     * Sets the constant multiplier for a graph
     * @param graph Specifies which graph to set constant for
     * @param constant The new constant value
     */
    public void setCurConst(int graph, int constant){
	switch(graph){
	case 1:
	    const1 = constant;
	    break;
	case 2:
	    const2 = constant;
	    break;
	case 3:
	    const3 = constant;
	    break;
	}
    }
    
    /**
     * Gets the current constant multiplier for a graph
     * @param graph Specifies which graph you want to know about
     * @return The current constant value
     */
    public int getCurConst(int graph){
	switch(graph){
	case 1:
	    return const1;
	case 2:
	    return const2;
	case 3:
	    return const3;
	}
	return 0;
    }
    
    /**
     * Sets the current function a particular graph should display
     * @param graph Specifies which graph to change
     * @param function Specifies which function the graph should display
     */
    public void setCurGraph(int graph, int function){
	switch(graph){
	case 1:
	    curGraph1 = function;
	    break;
	case 2:
	    curGraph2 = function;
	    break;
	case 3:
	    curGraph3 = function;
	    break;
	}
    }
    
    /**
     * Gets the function currently being displayed by a graph
     * @param graph Specifies which graph you want to know about
     * @return The current function being displayed by the specified graph
     */
    public int getCurGraph(int graph){
	switch(graph){
	case 1:
	    return curGraph1;
	case 2:
	    return curGraph2;
	case 3:
	    return curGraph3;
	}
	return 0;
    }
    
    public void setXVal(int n){
	xVal = n;
    }
    
    public void setYVal(int n){
	yVal = n;
    }
    
    public int getXVal(){
	return xVal;
    }
    
    public int getYVal(){
	return yVal;
    }
    
    public void setXMax(int n){
	xMax = n;
    }
    
    public void setYMax(int n){
	yMax = n;
    }
    
    public int getXMax(){
	return xMax;
    }
    
    public int getYMax(){
	return yMax;
    }
    
    private double fact(double n){
	double answer=n;
	
	n--;
	while(n >= 1){
	    answer *= n;
	    n--;
	}
	return answer;
    }
    
    private double f(double n, int curGraph) {
	switch (curGraph){
	case ONE:
	    return 1;
	case N:
	    return n;
	case N_SQUARED:
	    return Math.pow(n, 2);
	case N_CUBED:
	    return Math.pow(n, 3);
	case N_FOURTH:
	    return Math.pow(n, 4);
	case LOG_N:
	    return Math.log(n);
	case N_LOG_N:
	    return n*Math.log(n);
	case TWO_POW_N:
	    return Math.pow(2, n);
	case THREE_POW_N:
	    return Math.pow(3, n);
	case N_FACTORIAL:
	    return fact(n);
	case SQRT_N:
	    return Math.pow(n, .5);
	case N_POINT_ONE:
	    return Math.pow(n, .1);
	}
	//return (Math.cos(x/5) + Math.sin(x/7) + 2) * getSize().height / 4;
	//return (Math.pow(x, 2));
	return (1);
    }
    
    private void paintGrid(Graphics2D g2d){
	int height = getSize().height;
	int width = getSize().width;
	
	g2d.setPaint(Color.darkGray);
	for(int i=0;i<width;i+=(float)width/10){
	    for(int j=0;j<height;j+=(float)height/10){
		g2d.drawLine(i, height-j, i, height-j);
	    }
	}
    }
    
    private String makeXLabel(int i){
	float multiple = (((float)xMax/10)*i);
	String newstring = (""+multiple);
	int exponent = 0;
	
	if(xMax < 10000){
	    if(xMax <= 10){
		if(newstring.length() < 4)
		    return newstring;
		else
		    return newstring.substring(0, 4);
	    }else{
		return newstring.substring(0, newstring.indexOf("."));
	    }
	}else{
	    while(multiple >= 10){
		multiple /= 10;
		exponent++;
	    }
	    return multiple+"e"+exponent;
	}
    }
    
    private String makeYLabel(int i){
	float multiple = (((float)yMax/10)*i);
	String newstring = (""+multiple);
	int exponent = 0;
	
	if(yMax < 10000){
	    if(yMax <= 10){
		if(newstring.length() < 4)
		    return newstring;
		else
		    return newstring.substring(0, 4);
	    }else{
		return newstring.substring(0, newstring.indexOf("."));
	    }
	}else{
	    while(multiple >= 10){
		multiple /= 10;
		exponent++;
	    }
	    return multiple+"e"+exponent;
	}
    }
    
    private void paintScale(Graphics2D g2d){
	int height = getSize().height;
	int width = getSize().width;
	float yInc = (float)height/(float)10;
	float xInc = (float)width/(float)10;
	int i;
	String toPaint;
	g2d.setPaint(Color.black);
	
	// Y axis
	for(i=1;i<11;i++){
	    g2d.drawLine(2, (int)(height-((float)i*yInc)), 5, (int)(height-((float)i*yInc)));
	    toPaint = makeYLabel(i);
	    if(i < 10)
		g2d.drawString(toPaint, 7, height-(i*yInc-5));
	}
	
	// X axis
	for(i=1;i<11;i++){
	    g2d.drawLine((int)(width-(i*xInc)), height-2, (int)(width-(i*xInc)), height-5);
	    toPaint = makeXLabel(i);
	    if(i < 10)
		g2d.drawString(toPaint, (i*xInc-(toPaint.length()*3)), height-7);
	}
	
    }
    
    /*
      Does the actual painting of the graphs
    */
    public void paint(Graphics g){
	Graphics2D g2d = (Graphics2D)g;
	g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	int height = getSize().height;
	int width = getSize().width;
	int y1, y2;
	double n;
	
	super.paint(g);
	
	paintGrid(g2d);
	
	for (int x = 1 ; x < width ; x++) {
	    n = x;
	    
	    y1 = (int)((double)const1*(f((n/width)*xMax, curGraph1)*((double)height/(double)yMax)));
	    y2 = (int)((double)const1*(f(((n+1)/width)*xMax, curGraph1)*((double)height/(double)yMax)));
	    if(y2 > height){
		if(y1 > height)
		    break;
		y2 = height;
	    }
	    if((y1 < height)){
		g2d.setPaint(Color.red);
		g2d.drawLine((int)n, height-y1, (int)(n + 1), height-y2);
	    }
	    
	}

	for (int x = 1 ; x < width ; x++) {
	    n = x;

	    y1 = (int)((double)const2*(f((n/width)*xMax, curGraph2)*((double)height/(double)yMax)));
	    y2 = (int)((double)const2*(f(((n+1)/width)*xMax, curGraph2)*((double)height/(double)yMax)));
	    if(y2 > height){
		if(y1 > height)
		    break;
		y2 = height;
	    }
	    if((y1 < height)){
		g2d.setPaint(new Color(0, 200, 0));
		g2d.drawLine((int)n, height-y1, (int)(n + 1), height-y2);
	    }
	}

	for (int x = 1 ; x < width ; x++) {
	    n = x;
	    y1 = (int)((double)const3*(f((n/width)*xMax, curGraph3)*((double)height/(double)yMax)));
	    y2 = (int)((double)const3*(f(((n+1)/width)*xMax, curGraph3)*((double)height/(double)yMax)));
	    if(y2 > height){
		if(y1 > height)
		    break;
		y2 = height;
	    }
	    if((y1 < height)){
		g2d.setPaint(Color.blue);
		g2d.drawLine((int)n, height-y1, (int)(n + 1), height-y2);
	    }
	}
	
	paintScale(g2d);
	
    }
    private void jbInit() throws Exception {
	this.setBackground(Color.white);
    }
}











