import javax.swing.*;
public class ChessBoard {


    private static java.util.Random r = new java.util.Random();
    
    private static long tries;
    private boolean giveUp;
    
    public int boardSize;
    
    static final int verticalKnightMove[] =   { 2, 1, -1, -2, -2, -1,  1,  2};
    static final int horizontalKnightMove[] = { 1, 2,  2,  1, -1, -2, -2, -1};
    // The moves are:
    // 0  up 2, right 1
    // 1  up 1, right 2
    // 2  down 1, right 2
    // 3  down 2, right 1
    // 4  down 2, left 1
    // 5  down 1, left 2
    // 6  up 1, left 2
    // 7  up 2, left 1
    
    public int theBoard[][];
    //------------------------------------------------------------------------
    // The constructor
    //  
    public ChessBoard() { 
        boardSize=8;
        theBoard=new int[boardSize][boardSize];
        resetBoard();
    }
    public ChessBoard(int b) { 
        boardSize=b;
        theBoard=new int[boardSize][boardSize];
        resetBoard();
    }
    //------------------------------------------------------------------------
    // Reset the squares of the chessboard all to zero.
    //
    public void resetBoard() {
        for(int i=0;i<boardSize;i++) {
            for(int j=0;j<boardSize;j++) {
                theBoard[i][j]=0;
            }}
    }
    
    public boolean isEmpty(int x,int y) {
       return (theBoard[x][y]==0);
    }
   //--------------------------------------------------------------------
    // Return true if (xCoord,yCoord) is on the board, false otherwise.
    //
    public boolean isOnBoard(int x,int y) {
        if( x >= 0 && x < boardSize && y >= 0 && y < boardSize ) {
             return true;
        } else {
            return false;
        }
    }
    
    //-----------------------------------------------------------
    // Determine if there is a valid move
    public boolean knightMoveExists(int x,int y) {
        int i=0;
        while(i<8 && !isValidKnightMove(x,y,i)) {
            i++;
        }
        return (i<8);
    }
    //------------------------------------------------------------------------    
    // Determine if a knight move is valid.
    //--------------------
    // Precondition:  moveNumber is between 0 and 7, inclusive
    // Postcondition: If the move is valid  and return true.
    //                Otherwise return false.
    //
    public boolean isValidKnightMove(int x,int y,int moveNumber) {
        if(moveNumber < 0 || moveNumber >= 8) {
            return false;
        }
        else {
            int newX = x + horizontalKnightMove[moveNumber];
            int newY = y + verticalKnightMove[moveNumber];
            if( isOnBoard(newX,newY) && isEmpty(newX,newY) ) {
                return true;
            }
            else {
                return false;
            }
        }
    }
    
    public String findKnightTour(int x,int y) {
        if(isOnBoard(x,y)) {
            resetBoard();
            tries=0;
            giveUp=false;
            if(finishKnightTour(x,y,0)) {
                return(boardSize + " by "+ boardSize+" board, starting from("+x+","+y+") " 
                    +"\nSuccess after "+tries +" tries");
            } else if(giveUp) {
                return(boardSize + " by "+ boardSize+" board, starting from("+x+","+y+") " 
                    +"\nGave up after "+tries +" tries");
            }
            else {
                return(boardSize + " by "+ boardSize+" board, starting from("+x+","+y+") " 
                    +"\nNo tour exists");
            }
        } else {
            return("Not a valid starting spot");
        }
    }
    
    public boolean finishKnightTour(int x,int y,int index) {
        if(giveUp) return false;
        tries++;
        // This is so you can stop the algorithm from running in case
        // it is taking too long--so every once in a while you can 
        // choose to stop it.
        if( (tries%50000000) == 0 ) {                
            int choice = JOptionPane.showConfirmDialog(null,
                  "Have tried for "+tries+" steps.  Continue trying?", 
                  "Continue?", JOptionPane.YES_NO_OPTION);
            if(choice==JOptionPane.NO_OPTION) {
                giveUp=true;
                return false;
            } 
        }
        
        // If the spot is on the board and empty, we can put a knight there
        // and continue to the next spot.
        if(isOnBoard(x,y) && isEmpty(x,y)) {
            // Make the move since it is legal.
            index++;
            theBoard[x][y]=index;
            
            // If the index is big enough, that means we have finished.
            if(index==boardSize*boardSize) {
                return true;
            }
            // Try all 8 possible moves, recursively trying to finish
            // the tour.  If any succeed, return true and finish.
            // Otherwise, try the next one.
            for(int move=0;move<8;move++) {
                if(isValidKnightMove(x,y,move)) {
                    int newX = x + horizontalKnightMove[move];
                    int newY = y + verticalKnightMove[move];
                    if( finishKnightTour(newX,newY,index))
                        return true;
                }
            }
            // We have tried all solutions based on the choices made
            // so far, and none worked, so we reset the spot and
            // return false. (This is the backtracking part).
            theBoard[x][y]=0;
            //System.out.println(this);
            return false;
        } else {
            return false;
        }
    }
 
    //-----------------------------------------------------------
    // Random tour
     public int randomKnightTour() {
        resetBoard();
        int knightX=r.nextInt(boardSize);
        int knightY=r.nextInt(boardSize);
        int i=1;
        theBoard[knightX][knightY]=i;  // Place the knight in the first spot.      
         
             // As long as there is at least one move from the current spot,
             // keep trying random moves.
        while( knightMoveExists(knightX,knightY) ) {
            int move=r.nextInt(8);
            while( !isValidKnightMove(knightX,knightY,move)) {
                move = r.nextInt(8);
            }
            knightX += horizontalKnightMove[move];
            knightY += verticalKnightMove[move];
            i++;                               // Increment the number of moves           
            theBoard[knightX][knightY]=i;    // Set the knight in the next spot
        }
        return i;
    }  
   
    public String toString() {
        String theBoardString="";
        for(int i=0;i<boardSize;i++) {
            for(int j=0;j<boardSize;j++) {
                if(theBoard[i][j]<10) theBoardString +="  ";
                theBoardString += theBoard[i][j]+"  ";
            }
            theBoardString += "\n";
        }
        return theBoardString;
    }
}
