/*
 * KnightTour.java
 *
 * Created on September 24, 2002, 6:39 PM
 */
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

public class KnightTour extends JPanel implements ActionListener {
        JTextField theInput;
        JTextArea theOutput;
        JTextArea theLength;
        JButton tryRandomTour;
        JButton tryFullTour;
        java.util.Random r=new java.util.Random();
        
    public KnightTour() {
        setPreferredSize(new Dimension(300,300));
        theOutput=new JTextArea(10,10);
        theOutput.setEditable(false);
        theOutput.setBorder(new MatteBorder(10,10,10,10,Color.blue));
        
        theLength=new JTextArea();
        theLength.setEditable(false);
        
        theInput=new JTextField(3);
        
        tryRandomTour=new JButton("Try Random Tour");
        tryFullTour=new JButton("Try Full Tour");
        
        tryRandomTour.addActionListener(this);
        tryFullTour.addActionListener(this);
        
        JPanel buttonBox=new JPanel();
        buttonBox.add(tryRandomTour);
        buttonBox.add(tryFullTour);
        buttonBox.add(theInput);
        
        setLayout(new BorderLayout());
        add(buttonBox,BorderLayout.NORTH);
        add(theOutput,BorderLayout.CENTER);       
        add(theLength,BorderLayout.SOUTH);
    }
   public void actionPerformed(ActionEvent e) {
       // Clear the output
       theLength.setText("");
       theOutput.setText("");
       
       try {
            // get the size
            String sizeText=theInput.getText();
            int size;
            size=Integer.parseInt(sizeText);
        
            // Run the algorithm
            if( e.getSource()==tryRandomTour) {
               randomTour(size);
            }
            else { 
               fullTour(size);
            }
        } catch(NumberFormatException ex) {
            JOptionPane.showMessageDialog(null,
                  "Please input an integer!", 
                  "Input Error", JOptionPane.ERROR_MESSAGE);
        }
   }
   public void randomTour(int size) {
        ChessBoard myBoard=new ChessBoard(size);
        ChessBoard bestBoard=new ChessBoard(size);
        int tries=0;
        int length;
        int bestLength=0;
        do {
           tries++;
           length=myBoard.randomKnightTour();
           if(length>bestLength) {
              bestLength=length;
              bestBoard=myBoard;
              myBoard=new ChessBoard(size);
           }
        } while(length<size*size && tries<10000);
        
        theOutput.setText(bestBoard.toString());
        theLength.setText("Tour Length: "+bestLength+"\nNumber of Tries: "+tries);
   }
   public void fullTour(int size) {
        
        ChessBoard myBoard=new ChessBoard(size);
        theLength.setText(myBoard.findKnightTour(r.nextInt(size),r.nextInt(size)));
        theOutput.setText(""+myBoard);
   }
}
