import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * PictureApplet draws a picture in an applet
 */
public class ListenerExampleApplet extends JApplet
{   
	
    /**
     * In applets, the init method is where things get set up.
     * This is the only method that is needed if it is run as
     * an applet in a webpage.
     */
    public void init() 
    {
	   add(new ListenerExamplePanel());
    }
    
    /**
     * The main method, which allows us to run the application 
     * without using a webpage.  In other words, this is the method
     * that is called when you run a Java application. 
     */
    public static void main(String[] args) {  
    	ListenerExampleApplet frame = new ListenerExampleApplet();
	    frame.makeFrame();  
     }
    
    
    /**
     * The added things that must be done when implementing an application.
     */
    public void makeFrame() {
    	JFrame theFrame = new JFrame();
        theFrame.setTitle("A useless application");
        
        // This must be done so that the application exits when the window
        // is closed.  If this (or several other alternatives) is not done,
        // the application will still reside on your system.  That is, it
        // won't look like it is running any more, but it will be.
	    theFrame.addWindowListener (new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
        }});;
        
        // Instantiate the main drawing panel
        ListenerExamplePanel mainPanel=new ListenerExamplePanel();
        
        // Place all of the graphical components on the main window
        Container cont=theFrame.getContentPane();
        //cont.setLayout(new BorderLayout());
        cont.add(mainPanel,BorderLayout.CENTER);
  
        // Finish setting up the main window
        theFrame.setBackground(Color.white);
        theFrame.pack(); 
        theFrame.setSize(new Dimension(600,100));
        theFrame.setVisible(true);
    }
}
