/**
 * @author Charles Cusack
 * @version 1.0, September 2006
 *
 * A very simple model.  It just holds a String.
 */
import java.util.*;

public class FerzleModel {
    
    // The data for this model
    private String ferzle;
    
    // The list of registered listeners
    protected Set<FerzleListener> ferzleListeners;
    
    /**
     * The constructor, assuming an empty model
     */
    public FerzleModel() {
	    ferzle=new String("");
        ferzleListeners=new HashSet<FerzleListener>(1);
    }   
    
    /**
     * The accessor method for the Ferzle object
     * @return The Ferzle object
     */
    public String getFerzle() {
    	return ferzle;
    }
    
    /**
     * Mutator method.
     * @param ferzle the data element Ferzle in the model.
     */
    public void setFerzle(String ferzle) {
       this.ferzle=ferzle;	
       fireDataChanged();
    }

    /**
     * Add a listener to the list
     * @param listener the object desiring to listen to this class
     */
    public void addFerzleListener(FerzleListener listener) {
        ferzleListeners.add(listener);   
    }
    
    /**
     * remove a listener from the list
     * @param listener the object desiring to listen to this class
     */
    public void removeFerzleListener(FerzleListener listener) {
        ferzleListeners.remove(listener);   
    }
    
    /**
     * If any of the data in the model changes, this method takes care
     * of informing the listeners of the fact that the model has changed.
     */
    public void fireDataChanged() {
        Iterator iterator = new HashSet<FerzleListener>(ferzleListeners).iterator();
        while(iterator.hasNext() ) {
            FerzleListener listener=(FerzleListener) iterator.next();
            listener.ferzleDataChanged(new FerzleEvent(this));
        }
    }
}
