//--------------------------------------------------------------------------
// AnalogClock.java
// Written by Chuck Cusack
// October, 2001
//
// Extends AbstractClock so it looks like a regular analog clock.
//--------------------------------------------------------------------------
import aLibrary.*;
import java.awt.*;
//--------------------------------------------------------------------------
public class AnalogClock extends Clock {
	ALine HourHand, MinuteHand, SecondHand; // the moving clock hands
	AOval ClockInside;                      // the clock face inside
	AOval ClockOutside;                     // the clock face outside
	int xCenter, yCenter;	                // center of the clock
//--------------------------------------------------------------------------
// The constructor
// Postcondition: An analog clock is draw as specified int the methods
//     below, and it's time is set according to hr, min, and sec parameters.
//
  public AnalogClock(int hr,int min,int sec) {
        super(0,0,550,500,hr,min,sec);  // Call the constructor from Clock
         }
//--------------------------------------------------------------------------
// Draws the face of the clock.
// Postcondition: draws the clock face, including numbers
//
  public void drawFace() {
       // Draw the frame of the clock
          ClockOutside = new AOval(0, 0, 450, 450);
          ClockOutside.setColor(Color.black);
          ClockOutside.setToFill();
          ClockOutside.place(this);

       // Draw the inside of the clock
          ClockInside = new AOval(25, 25, 400, 400);
          ClockInside.setColor(new Color(100,200,100));
          ClockInside.setToFill();
          ClockInside.place(this);

       // Set the center of the clock to the appropriate values
          xCenter = 225;
          yCenter = 225;

       // Draw the numbers on the face
          for (int i=0; i<12; ++i) {
            double Agl=i/12.0*2*Math.PI+(3*Math.PI/2);
            ALabel aNumber=new ALabel(xCenter-25+(int)(Math.cos(Agl)*175),
                        yCenter-15+(int)(Math.sin(Agl)*175),45,30);
            if (i == 0)  aNumber.setText("12");
            else         aNumber.setText(String.valueOf(i));
            aNumber.setFontSize(36);
            aNumber.place(this);
        }
        this.repaint();
  }
//--------------------------------------------------------------------------
// Draws the seconds like the hands on a analog clock.
// Postcondition: The second hand is drawn according the the value of
//   the "second" variable
//
  public void drawSeconds() {
     // get rid of the old hand, if it is there
        if(SecondHand!=null)  SecondHand.remove();

     // compute the hand angle
        double SecondAgl=2*Math.PI*(getSeconds()/60.0) + (3*Math.PI/2);

     // create the new hand according to the computed angle
        SecondHand=new ALine(xCenter,yCenter,
            xCenter+(int)(Math.cos(SecondAgl)*190),
            yCenter+(int)(Math.sin(SecondAgl)*190));
        SecondHand.setColor(Color.red);
        SecondHand.place(this);
        SecondHand.repaint();
        this.repaint();
        }
//--------------------------------------------------------------------------
// Draws the minutes like the hands on a analog clock.
// Postcondition: The minute hand is drawn according the the value of
//   the "miunte" variable
//
  public void drawMinutes() {

     // get rid of the old hand, if it is there
        if(MinuteHand!=null) MinuteHand.remove();

     // compute the hand angle
        double MinuteAgl=2*Math.PI*(getMinutes()/60.0) + (3*Math.PI/2)
                        +2*Math.PI*(getSeconds()/(60.0*60));

     // create the new hand according to the computed angle
        MinuteHand = new ALine(xCenter, yCenter,
              xCenter+(int)(Math.cos(MinuteAgl)*150),
              yCenter+(int)(Math.sin(MinuteAgl)*150));
        MinuteHand.setColor(Color.blue);
        MinuteHand.place(this);
        this.repaint();
        }
//--------------------------------------------------------------------------
// Draws the hour hand like the hands on a analog clock.
// Postcondition: The hour hand is drawn according the the value of
//   the "hour" variable
//
   public void drawHours() {
     // get rid of the old hand, if it is there

        if(HourHand!=null)  HourHand.remove();

     // compute the hand angle
        double HourAgl=2*Math.PI*(getHours()/12.0) + (3*Math.PI/2)
                      +2*Math.PI*(getMinutes()/(60.0*12))+
                      +2*Math.PI*(getSeconds()/(60.0*60*12));

     // create the new hand according to the computed angle
        HourHand = new ALine(xCenter, yCenter,
              xCenter+(int)(Math.cos(HourAgl)*100),
              yCenter+(int)(Math.sin(HourAgl)*100));
        HourHand.setColor(Color.orange);
        HourHand.place(this);
        this.repaint();
        }
//--------------------------------------------------------------------------
}
