// BarClock.java
// Written by Chuck Cusack
// October, 2001
//
// Extends AbstractClock so it looks like a Bar clock.
//
import aLibrary.*;
import java.awt.*;

public class BarClock extends Clock {
	ARectangle Hour, Minute, Second; // the Times
  public BarClock(int hr,int min,int sec) {
        super(0,0,450,500,hr,min,sec);
         }
  public void drawFace() {
  }
  public void drawHours() {
        int darkness=(int)(255-255*getHours()/12.0);
        if(Hour==null) {
          Hour=new ARectangle(50,50,0,0);
          Hour.place(this);
        }
        Hour.setSize(50,25+getHours()*25);
        Hour.setToFill();
        Hour.setColor(new Color(darkness,0,0));
  }
  public void drawMinutes() {
        int darkness=(int)(255-255*getMinutes()/60.0);
        if(Minute==null) {
          Minute=new ARectangle(150,50,0,0);
          Minute.place(this);
        }
        Minute.setSize(50,5+getMinutes()*5);
        Minute.setToFill();
        Minute.setColor(new Color(0,darkness,0));
  }
  public void drawSeconds() {
        int darkness=(int)(255-255*getSeconds()/60.0);
        if(Second==null) {
          Second=new ARectangle(250,50,0,0);
          Second.place(this);
        }
        Second.setSize(50,getSeconds()*5);
        Second.setToFill();
        Second.setColor(new Color(0,0,darkness));
  }
}
