//---------------------------------------------------------------------------
//AbstractClock.java
// Written by Chuck Cusack
// October, 2001
//
// An abstract class to simulate a clock.
// Extend to make it graphical however you choose.
//---------------------------------------------------------------------------
import aLibrary.*;
//---------------------------------------------------------------------------
public abstract class Clock extends AView {
  protected int second;  // The seconds: stores 0-59
  protected int minute;  // The minutes: stores 0-59
  protected int hour;    // The hour   : stores 0-11, where 0 is really 12
  private ClockTimer myTimer;  // The time-keeping object
//---------------------------------------------------------------------------
// The constructor.
// Postcondition: The clock is created in the place and of the size requested.
//    The time is set to hr,min,sec.
//    The clock is drawn according to the DrawClock method.
  public Clock(int x,int y,int width,int height,int hr,int min,int sec) {

     // Create the AView
        super(x,y,width,height);

     // Set the time according to the parameters
        second=sec;
        minute=min;
        hour=hr;
        myTimer=new ClockTimer(this);
        myTimer.scheduleEvents(.1);
     // Draw the clock according to the method provided by the subclass.
        drawClock();
        this.repaint();
  }
//---------------------------------------------------------------------------
// Refreshes the clock according to the current time.
// Postcondition: The clock is redrawn according to the current time.
//
  public void refresh() {
      drawTimes();
  }
//---------------------------------------------------------------------------
// Postcondition: The clock is drawn according to the methods
//    drawFace and drawTimes.
//
  protected void drawClock() {
      drawFace();
      drawTimes();
      this.repaint();
      }
//---------------------------------------------------------------------------
// Postcondtion: The time portion of the clock is drawn according to the
//    three methods listed, which should be overriden by the subclass.
//
  protected void drawTimes() {
      drawSeconds();
      drawMinutes();
      drawHours();
  }

//---------------------------------------------------------------------------
// Returns: second
//
  public int getSeconds() {
      return second;
      }
//---------------------------------------------------------------------------
// Postcondition: second==sec, and the drawn clock is updated as defined by
//    the drawing method(s).
//
  public boolean setSeconds(int sec) {
     if(sec>=0 && sec<60) {
       second=sec;
       drawTimes();
       return true;
       }
      else
        return false;
  }
//---------------------------------------------------------------------------
// Postcondition: second==(old_seconds+1)%60.
//    if seconds==0, incrementMinutes is called.
//    The drawn clock is updated
//
  public void incrementSeconds() {
      second++;
      if(second==60) {
          second=0;
          incrementMinutes();
      }
      drawTimes();
  }
//---------------------------------------------------------------------------
// Returns: minute
//
  public int getMinutes() {
      return minute;
  }
//---------------------------------------------------------------------------
// Postcondition: The minutes of the clock are set to "sec" and the drawn
//     clock is updated as defined by the drawing method(s).
//
  public boolean setMinutes(int min) {
     if(min>=0 && min<60) {
       minute=min;
       drawTimes();
       return true;
       }
     else
       return false;
  }
//---------------------------------------------------------------------------
// Postcondition: minute==(old_minutes+1)%60.
//    if minutes==0, incrementHours is called.
//    The drawn clock is updated
//
  public void incrementMinutes() {
      minute++;
      if(minute==60) {
          minute=0;
          incrementHours();
      }
      drawTimes();
  }
//---------------------------------------------------------------------------
// Returns: hour if hour!=0 and 12 if hour==0.
//
  public int getHours() {
      if(hour==0)
          return 12;
      else
          return hour;
  }
//---------------------------------------------------------------------------
// Postcondition: The hours of the clock are set to "sec" and the drawn
//     clock is updated as defined by the drawing method(s).
//
  public boolean setHours(int hr) {
     if(hr>=0 && hr<12) {
       hour=hr;
       drawTimes();
       return true;
       }
     else
       return false;
  }
//---------------------------------------------------------------------------
// Postcondition: hour==(old_hours+1)%12.
//    The drawn clock is updated
//
  public void incrementHours() {
      hour++;
      if(hour==12) {
         hour=0;
      }
      drawTimes();
  }

//---------------------------------------------------------------------------
// The following methods should be overridden to draw the clock however the
// subclass wishes it to be drawn
//
  protected abstract void drawFace();
  protected abstract void drawSeconds();
  protected abstract void drawMinutes();
  protected abstract void drawHours();
//---------------------------------------------------------------------------
}
