//--------------------------------------------------------------------------
// Digit.java
// Written by Chuck Cusack
// October, 2001
//
// A Digit used in a Digital Clock
//--------------------------------------------------------------------------
import aLibrary.*;
import java.awt.Color;
//--------------------------------------------------------------------------

public class Digit extends AView{

  private ARoundRectangle left_top;     // These are the 7 cells used to
  private ARoundRectangle left_bottom;  // display a digit
  private ARoundRectangle right_top;
  private ARoundRectangle right_bottom;
  private ARoundRectangle bottom_line;
  private ARoundRectangle top_line;
  private ARoundRectangle middle_line;

  private AOval top_dot;           // the colon dots if a digit is a colon
  private AOval bottom_dot;

  private int value;                     // The current value of the digit
              // 0-9 mean 0-9, 10 means colon, everything else means space
//--------------------------------------------------------------------------
// Constructor
// Postcondition: A digit is drawn to represent the number val.
//
  public Digit(int x,int y,int val) {

  // create an AView of size 35x50 at location x,y of the parent container.
     super(x,y,35,50);

  // set the value of the digit
     value=val;

  // Draw the digit
     initCells();
     setDigit(value);
     this.repaint();
  }
//--------------------------------------------------------------------------
// Constructor
// Postcondition: A digit is drawn to represent a space
//
  public Digit(int x,int y) {
     super(x,y,35,50);
     value=11;
     initCells();
     setDigit(value); // blank
     this.repaint();
  }
//--------------------------------------------------------------------------
// Change the digit to value==val, and draw it as such
// Postcondition: The digit is drawn to repsrent the value val.
//
  public void setDigit(int val) {
     value=val;
     switch(value){
        case 0:
           drawZero();
           break;
        case 1:
           drawOne();
           break;
        case 2:
           drawTwo();
           break;
        case 3:
           drawThree();
           break;
        case 4:
           drawFour();
           break;
        case 5:
           drawFive();
           break;
        case 6:
           drawSix();
           break;
        case 7:
           drawSeven();
           break;
        case 8:
           drawEight();
           break;
        case 9:
           drawNine();
           break;
        case 10:
           drawColon();
           break;
        default:
           drawBlank();
           break;
        }
        this.repaint();
  }
//--------------------------------------------------------------------------
// Draw the digit as '0'
//
  private void drawZero() {
      left_top.place(this);
      left_bottom.place(this);
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.place(this);
      top_line.place(this);
      middle_line.remove();
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '1'
//
  private void drawOne() {
      left_top.remove();
      left_bottom.remove();
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.remove();
      top_line.remove();
      middle_line.remove();
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '2'
//
  private void drawTwo() {
      left_top.remove();
      left_bottom.place(this);
      right_top.place(this);
      right_bottom.remove();
      bottom_line.place(this);
      top_line.place(this);
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }

//--------------------------------------------------------------------------
// Draw the digit as '3'
//
  private void drawThree() {
      left_top.remove();
      left_bottom.remove();
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.place(this);
      top_line.place(this);
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '4'
//
  private void drawFour() {
      left_top.place(this);
      left_bottom.remove();
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.remove();
      top_line.remove();
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '5'
//
  private void drawFive() {
      left_top.place(this);
      left_bottom.remove();
      right_top.remove();
      right_bottom.place(this);
      bottom_line.place(this);
      top_line.place(this);
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '6'
//
  private void drawSix() {
      left_top.place(this);
      left_bottom.place(this);
      right_top.remove();
      right_bottom.place(this);
      bottom_line.place(this);
      top_line.place(this);
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '7'
//
  private void drawSeven() {
      left_top.remove();
      left_bottom.remove();
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.remove();
      top_line.place(this);
      middle_line.remove();
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '8'
//
  private void drawEight() {
      left_top.place(this);
      left_bottom.place(this);
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.place(this);
      top_line.place(this);
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as '9'
//
  private void drawNine() {
      left_top.place(this);
      left_bottom.remove();
      right_top.place(this);
      right_bottom.place(this);
      bottom_line.remove();
      top_line.place(this);
      middle_line.place(this);
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as ':'
//
  private void drawColon() {
      left_top.remove();
      left_bottom.remove();
      right_top.remove();
      right_bottom.remove();
      bottom_line.remove();
      top_line.remove();
      middle_line.remove();
      top_dot.place(this);
      bottom_dot.place(this);
      this.repaint();
      }
//--------------------------------------------------------------------------
// Draw the digit as ' '
//
  private void drawBlank() {
      left_top.remove();
      left_bottom.remove();
      right_top.remove();
      right_bottom.remove();
      bottom_line.remove();
      top_line.remove();
      middle_line.remove();
      top_dot.remove();
      bottom_dot.remove();
      this.repaint();
      }
//--------------------------------------------------------------------------
// Declare all of the digital cells, but leave them off the for now.
//
  private void initCells(){
    left_top = new ARoundRectangle(0,5,6,20);
    left_top.setColor(Color.green);
    left_top.setToFill();

    left_bottom = new ARoundRectangle(0,27,6,19);
    left_bottom.setColor(Color.green);
    left_bottom.setToFill();

    right_top = new ARoundRectangle(30,5,6,20);
    right_top.setColor(Color.green);
    right_top.setToFill();

    right_bottom = new ARoundRectangle(30,27,6,19);
    right_bottom.setColor(Color.green);
    right_bottom.setToFill();

    bottom_line = new ARoundRectangle(7,45,22,6);
    bottom_line.setColor(Color.green);
    bottom_line.setToFill();

    top_line = new ARoundRectangle(7,0,22,6);
    top_line.setColor(Color.green);
    top_line.setToFill();

    middle_line = new ARoundRectangle(7,22,21,6);
    middle_line.setColor(Color.green);
    middle_line.setToFill();

    top_dot = new AOval(13,15,8,8);
    top_dot.setColor(Color.blue);
    top_dot.setToFill();

    bottom_dot = new AOval(13,30,8,8);
    bottom_dot.setColor(Color.blue);
    bottom_dot.setToFill();
  }
//--------------------------------------------------------------------------
}
