//--------------------------------------------------------------------------
// DigitalClock.java
// Written by Chuck Cusack
// October, 2001
//
// Extends Clock so it looks like a regular digital clock.
//--------------------------------------------------------------------------
import aLibrary.*;
import java.awt.*;
//--------------------------------------------------------------------------
public class DigitalClock extends Clock {
	ARoundRectangle ClockInside;  // The inside of the clock
	ARoundRectangle ClockOutside; // The frame of the clock
    Digit Hour1, Hour2;           // The hour digits
    Digit Minute1, Minute2;       // The minute digits
    Digit Second1, Second2;       // The second digits
    Digit Colon1,Colon2;          // The colons 
//--------------------------------------------------------------------------
// Postcondtion: A digital clock is drawn displaying time hr:min:sec
//
  public DigitalClock(int hr,int min,int sec) {
         super(50,200,350,150,hr,min,sec);
         }
//--------------------------------------------------------------------------
// Draw the clock as an round rectangle with digits from class Digit.
//
  public void drawFace() {
          ClockOutside = new ARoundRectangle(5, 5, 325, 90);
          ClockOutside.setColor(Color.black);
          ClockOutside.setToFill();
          ClockOutside.place(this);

          ClockInside = new ARoundRectangle(20, 20, 295, 60);
          ClockInside.setColor(Color.red);
          ClockInside.setToFill();
          ClockInside.place(this);
          Hour1=new Digit(25,25);
          Hour1.place(this);
          Hour2=new Digit(65,25);
          Hour2.place(this);
          Colon1=new Digit(95,25,10);
          Colon1.place(this);
          Minute1=new Digit(125,25);
          Minute1.place(this);
          Minute2=new Digit(165,25);
          Minute2.place(this);
          Colon2=new Digit(195,25,10);
          Colon2.place(this);
          Second1=new Digit(225,25);
          Second1.place(this);
          Second2=new Digit(265,25);
          Second2.place(this);
          this.repaint();
  }
//--------------------------------------------------------------------------
// Postcondition: The seconds are drawn as digital numbers
//
  public void drawSeconds() {
        Second1.setDigit(getSeconds()/10);
        Second2.setDigit(getSeconds()%10);
        this.repaint();
        }
//--------------------------------------------------------------------------
// Postcondition: The minutes are drawn as digital numbers
//
  public void drawMinutes() {
        Minute1.setDigit(getMinutes()/10);
        Minute2.setDigit(getMinutes()%10);
        this.repaint();
        }
//--------------------------------------------------------------------------
// Postcondition: The hours are drawn as digital numbers
//
  public void drawHours() {
        Hour1.setDigit(getHours()/10);
        Hour2.setDigit(getHours()%10);
        this.repaint();
        }
//--------------------------------------------------------------------------
}
