//-----------------------------------------------------------
// myDigitalClocks.java
// Written by Chuck Cusack
// October, 2001
//
// Displays and updates various clocks.
// Uses instances of DigitalClock and AnalogClock
//-----------------------------------------------------------
import java.awt.event.*;
import aLibrary.*;
//-----------------------------------------------------------
public class FunctionalClocks extends AWindow {
    private Clock myClock[];        // The array of clocks
    private int placedClock;        // 1==Analog, 2==Digital
    private AButton togButton;     // Switch Clocks Button
//---------------------------------------------------------------
// The contructor
// Postcondition: A 450x500 window is created with the one button
//    along the bottom, and the digital clock in place.
//    The button switches between various clock modes
    public FunctionalClocks() {
        super(50,50,450,500);              // Create the AWindow
     // Create the clocks
        myClock=new Clock[4];
        myClock[0]=new AnalogClock(0,0,0);
        myClock[0].place(this);
        myClock[0].setVisible(false);

        myClock[1]=new DigitalClock(0,0,0);
        myClock[1].place(this);
        placedClock=1;

        myClock[2]=new BarClock(0,0,0);
        myClock[2].place(this);
        myClock[2].setVisible(false);

        myClock[3]=new MovingClock(0,0,0);
        myClock[3].place(this);
        myClock[3].setVisible(false);

     // Set up the toggle button
        togButton=new AButton(340,460,100,30);
        togButton.setText("Toggle");
        togButton.addActionListener(this);
        togButton.place(this);

        this.repaint();
    }
//-------------------------------------------------------------------------
// The action handler for the buttons
//
    public void actionPerformed(ActionEvent e) {
        if(e.getSource()==togButton) {
            myClock[placedClock].setVisible(false);
            placedClock=(placedClock+1)%myClock.length;
            myClock[placedClock].setVisible(true);
            this.repaint();
        }
    }
//-------------------------------------------------------------------------
}
