// BarClock.java
// Written by Chuck Cusack
// October, 2001
//
// Extends AbstractClock so it looks like a Bar clock.
//
import aLibrary.*;
import java.awt.*;

public class MovingClock extends Clock {
    private ALabel Seconds;
    private ALabel Minutes;
    private ALabel Hours;
    private ARoundRectangle background, frame;
  public MovingClock(int hr,int min,int sec) {
     super(0,0,450,500,hr,min,sec);
  }
  protected void drawFace() {
      frame=new ARoundRectangle(0,0,450,450);
      frame.setColor(Color.black);
      frame.setToFill();
      frame.place(this);

      background=new ARoundRectangle(10,10,430,430);
      background.setColor(Color.yellow);
      background.setToFill();
      background.place(this);
  }
  protected void drawSeconds() {
    int x,y;
    if(Seconds==null) {
        Seconds=new ALabel(50,50,175,125);
        }
    x=(int)(5-Math.random()*10);
    y=(int)(5-Math.random()*10);
    if(x+Seconds.getX()+Seconds.getWidth()<this.getWidth()-20 &&
       y+Seconds.getY()+Seconds.getHeight()<this.getWidth()-20 &&
       x+Seconds.getX()>=20 && y+Seconds.getY()>=20 ) {
               Seconds.translate(x,y);
               }
    Seconds.setFontSize(getSeconds()+10);
    Seconds.setColor(Color.blue);
    Seconds.setText(""+getSeconds());
    Seconds.place(this);
    this.repaint();
  }
  protected void drawMinutes() {
      int x,y;
    if(Minutes==null) {
        Minutes=new ALabel(200,200,200,150);
        }
    x=(int)(5-Math.random()*10);
    y=(int)(5-Math.random()*10);
    if(x+Minutes.getX()+Minutes.getWidth()<this.getWidth()-50 &&
       y+Minutes.getY()+Minutes.getHeight()<this.getWidth()-50 &&
       x+Minutes.getX()>=50 && y+Minutes.getY()>=50 ) {
               Minutes.translate(x,y);
               }
    Minutes.setFontSize(getMinutes()+80);
    Minutes.setColor(Color.red);
    Minutes.setText(""+getMinutes());
    Minutes.place(this);
    this.repaint();
  }
  protected void drawHours() {
        int x,y;
    if(Hours==null) {
        Hours=new ALabel(150,150,250,150);
        }
    x=(int)(5-Math.random()*10);
    y=(int)(5-Math.random()*10);
    if(x+Hours.getX()+Hours.getWidth()<this.getWidth()-50 &&
       y+Hours.getY()+Hours.getHeight()<this.getWidth()-50 &&
       x+Hours.getX()>=50 && y+Hours.getY()>=50 ) {
               Hours.translate(x,y);
               }
    Hours.setFontSize(getHours()*2+150);
    Hours.setColor(Color.green);
    Hours.setText(""+getHours());
    Hours.place(this);
    this.repaint();
  }
//----------------------------------------------
}