import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.geom.*;

/**
 * A class draws a picture on a panel
 *
 */
public class PicturePanel extends JPanel 
{
    int numberClicks=1;
    int days=1;
    Color Browns[]=new Color[4];
    int xCoordinate=0;
    int yCoordinate=0;
    ArrayList<HairLock> standardHair;
    ArrayList<LongHairLock> longHair;

    int originX=75;
    int originY=138;
     
    /**
     * Applets start by calling init() instead of a constructor.
     */
    public PicturePanel() 
    {
        Browns[0]=new Color(50,50,0);
        Browns[1]=new Color(75,75,0);
        Browns[2]=new Color(100,100,0);
        Browns[3]=new Color(150,150,0);
        MouseHandler mh=new MouseHandler();
        addMouseListener(mh);
        addMouseMotionListener(mh);
        
        
        //Create Standard Haircut.
        standardHair=new ArrayList<HairLock>();
         for(int i=-26;i<26;i+=2) {
             for(int j=0;j<20;j+=2) {
                 int theColor=(int) (Math.random()*4);
                 Color lockColor = Browns[theColor];
                 int x1=75 + i + (int) (Math.random()*4);
                 int y1=105 + (int) (Math.random()*6) + (i*i+j*j)/30;
                 int x2=x1+(int)(Math.random()*8)-4;
                 int y2=y1-6;
                 HairLock l = new HairLock(x1,y1,x2,y2,lockColor);
                 standardHair.add(l);
             }
         }
         
        longHair=new ArrayList<LongHairLock>();
    }

    /**
     * This method is called whenever the applet needs to be drawn.
     */
    public void paintComponent(Graphics g) 
    {
        super.paintComponent(g);
        
        // Moves the drawing coordinate over and down by 100
        // I am only doing this because after drawing everything, 
        //I decided I want more space on the top and left side.
        // You probably shouldn't need to use this in your drawing...
        
        g.translate(originX-75,originY-138);
        
        drawStuff(g);
        drawFace(g);
        drawStandardHair(g);
        drawLongHair(g);
        //for(int i=0;i<numberClicks;i++)
        //    drawLock(i,g);
    }

    /**
     * The method that draws the face
     */
    private void drawFace(Graphics g)
    {
        // Head
         g.setColor(new Color(240,240,100));
         g.fillOval(50,105,50,65);
         // Ears
         g.fillOval(45,130,10,16);
         g.fillOval(96,130,10,16);
         // Eyes
         g.setColor(Color.white);
         g.fillOval(55,130,16,10);
         g.fillOval(80,130,16,10);
         //Black part of eyes
         g.setColor(Color.black);
         g.fillOval(58,131,8,8);
         g.fillOval(83,131,8,8);
         // colored part of eyes
         g.setColor(new Color(0,150,0));
         g.fillOval(59,132,5,5);
         g.fillOval(84,132,5,5);
         
         //Mouth
         g.setColor(new Color(200,100,100));
         g.fillArc(65,152,20,5,160,220);
         //Nose
         g.setColor(new Color(200,200,80));
         g.fillArc(68,120,15,30,250,60);
         

    }
   /**
     * The method that draws the standard haircut.
     */
    private void drawStandardHair(Graphics g)
    {
        Color old=g.getColor();
        for(HairLock a: standardHair) {
            a.drawLock(g);
        }
        g.setColor(old);
    }    
    /** 
     * The method that draws the longer hair.
     */
    private void drawLongHair(Graphics g)
    {
        Color old=g.getColor();
        for(LongHairLock a: longHair) {
            a.drawLock(g);
        }
        g.setColor(old);
    }
    
    /**
     * A method to draw other stuff on the applet.
     */
    private void drawStuff(Graphics g)
    {
        // Change the font and color.
        g.setFont(new Font("Times Roman",Font.BOLD,24));
        g.setColor(Color.BLUE);
        
        g.drawString("Dr. Cusack",10,30);
        
        
        // Change color/font again.
        g.setColor(Color.BLACK);
        g.setFont(new Font("Times Roman",Font.PLAIN,12));
        if(numberClicks==0) 
        {
            g.drawString("Haircut!",120,120);
        }
        g.drawString("Day "+days,120,150);
        g.drawString("Click the mouse button and the hair will grow",10,180);
        g.drawString("There is a 1% chance of a haircut each click",10,200);
        
        // Change the font and color
        g.setColor(new Color(50,150,100));
        g.setFont(new Font("Arial",Font.ITALIC,16));
        
        g.drawString("Mouse Entered at ("+xCoordinate+", "+yCoordinate+")",10,220);
        
        // Change the font and color
        g.setColor(new Color(.75f,.25f,.1f));
        g.setFont(new Font("Arial",Font.ITALIC,16));
        g.drawString("Drag the head around the screen",10,240);
        
    }

    /**
     * This method adds more hair.
     */
    private void addLocks(int length) 
    {
        for(int j=-26;j<26;j+=1) 
        {
            int x1=75 + (j) + (int) (Math.random()*4);
            int y1=105 + (int) (Math.random()*6) + (j*j)/30;
            int theColor=(int) (Math.random()*4);
            Color lockColor = Browns[theColor];
            LongHairLock a = new LongHairLock(x1,y1,length,lockColor);
            longHair.add(a);
        }
    }
    
    //---------------------------------------------------------------
    // A class to handle the mouse events for the applet.
    // This is one of several ways of handling mouse events.
    // Another is to make this class implement a MouseListener
    // interface.
    // There are advantages and disadvantages of doing each.
    //
    private class MouseHandler extends MouseAdapter implements MouseMotionListener
    {
        /**
         * Overridden from MouseAdapter
         */
        public void mouseClicked(MouseEvent e) 
        {
            if(Math.random()*101 > 99) {
                 numberClicks=0;
                 longHair.clear();
            } else {
                 numberClicks++;
                 addLocks(numberClicks);
            }
            days++;
            repaint();
        }
        /**
         * Overridden from MouseAdapter
         */
        public void mouseEntered(MouseEvent e)
        {
            xCoordinate = e.getX();
            yCoordinate = e.getY();
            repaint();
        }
        /**
         * From the MouseMotionListener interface.
         * I don't want this to do anything, but I need to implement it.
         * So, I implement it donig nothing.
         */
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
        }
        /**
         * From the MouseMotionListener interface
         * This allows us to move the drawing around the screen.  Cool.
         */
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            
            System.out.println("Trying to drag");
            System.out.println("X="+x+" y="+y+"    ox="+originX+"   oy="+originY);
 
            // If the head is selected.
            if(Math.sqrt(Math.pow(Math.abs(x-originX),2)+Math.pow(Math.abs(y-originY),2))<25) {
                originX=x;
                originY=y;
                repaint();
            
            System.out.println("sucess");
            }
        }
        
    }
    
    
    //---------------------------------------------------------------
    // HairLock class.  Stores 1 strand of straight hair.
    private class HairLock {
        int x1,y1, x2, y2;
        Color myColor;
        public HairLock(int x1,int y1,int x2,int y2,Color c) {
            this.x1=x1;
            this.y1=y1;
            this.x2=x2;
            this.y2=y2;
            myColor=c;
        }
        public void drawLock(Graphics g) {
            g.setColor(myColor);
            g.drawLine(x1,y1,x2,y2);
            
        }
    }
    //---------------------------------------------------------------
    // LongHairLock class.  Stores a longer "curvey" lock of hair.
    private class LongHairLock {
        int[] x;
        int[] y;
        int length;
        Color myColor;
        // (x,y) is the root of the hair.  The rest is random.
        public LongHairLock(int xStart,int yStart, int length, Color c) {
            myColor=c;
            this.length=length;
            x=new int[length];
            y=new int[length];
            x[0]=xStart;
            y[0]=yStart;
            // Attempting to draw strands of hair that go in "normal"
            // directions.  That is, trying to make the hair look right.
            for(int i=1;i<length;i++)
            {
                if(x[i-1]>100) {
                   x[i]=x[i-1] + (int) (Math.random()*17)-6;
                }
                else if(x[i-1]<50) {
                   x[i]=x[i-1] + (int) (Math.random()*17)-10;
                }
                else {
                   x[i]=x[i-1] + (int) (Math.random()*17)-8;
                }
                y[i]=y[i-1] - (int) (Math.random()*11)+3;
            }
        }
        public void drawLock(Graphics g) {
            g.setColor(myColor);
            g.drawPolyline(x,y,length);
        }
    } 
    

    
}
