import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;

/**
 * A class that lets people play with set operations among various sets
 *
 * @author Cory Lueninghoener <cluening@cse.unl.edu>
 */
public class SetOperations extends JApplet {
    String universeNumbers = "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16";
    String[] aBoxNumbers = {"1, 2, 3", "2, 4, 6, 8", "10, 12, 14, 16"};
    String[] bBoxNumbers = {"1, 2, 3, 5, 8, 13", "1, 2, 4, 8, 16", "1, 3, 5, 7, 9"};
    
    String universeAlphabet = "A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z";
    String[] aBoxAlphabet = {"A, B, C, D", "A, E, I, O, U", "E, L, N, R, S, T"};
    String[] bBoxAlphabet = {"Z, Y, L", "C, S, E", "B, C, D, F, G, H"};
    
    String universeAnimals = "Cow, Pig, Horse, Dog, Cat, Fish, Chicken";
    String[] aBoxAnimals = {"Cow, Pig, Horse, Chicken", "Dog, Cat, Fish"};
    String[] bBoxAnimals = {"Fish, Chicken", "Horse, Cow", "Cow, Pig, Horse, Dog, Cat"};
    
    boolean isStandalone = false;
    JPanel jPanel1 = new JPanel();
    JLabel universeLabel = new JLabel();
    JComboBox aBox = new JComboBox();
    JLabel aLabel = new JLabel();
    JComboBox universeBox = new JComboBox();
    JLabel bLabel = new JLabel();
    JComboBox bBox = new JComboBox();
    JLabel guessLabel = new JLabel();
    JTextField guessBox = new JTextField();
    JLabel answerLabel = new JLabel();
    JTextField answerBox = new JTextField();
    JLabel operationLabel = new JLabel();
    JPanel operationPanel = new JPanel();
    JComboBox operationBox = new JComboBox();
    JButton checkButton = new JButton();
    JButton showButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField statusBar = new JTextField();
    /**Get a parameter value*/
    public String getParameter(String key, String def) {
	return isStandalone ? System.getProperty(key, def) :
	    (getParameter(key) != null ? getParameter(key) : def);
    }
    
    /**Construct the applet*/
    public SetOperations() {
    }
    /**Initialize the applet*/
    public void init() {
	try {
	    jbInit();
	}
	catch(Exception e) {
	    e.printStackTrace();
	}
	//setUIFont(new javax.swing.plaf.FontUIResource("Lucida Sans", Font.BOLD, 12));
	FontFixer.setUIFont("Lucida Sans");
	SwingUtilities.updateComponentTreeUI(jPanel1);
    }
    //public static void setUIFont(javax.swing.plaf.FontUIResource f){
    public static void setUIFont(String name){
	javax.swing.plaf.FontUIResource f;
	System.out.println("Fixing fonts");
	java.util.Enumeration keys = UIManager.getDefaults().keys();
	while (keys.hasMoreElements()) {
	    Object key = keys.nextElement();
	    Object value = UIManager.get (key);
	    if (value instanceof javax.swing.plaf.FontUIResource){
		//f = new javax.swing.plaf.FontUIResource(name, ((Font)value).getStyle(), ((Font)value).getSize());
		f = new javax.swing.plaf.FontUIResource(name, Font.PLAIN, ((Font)value).getSize());
		System.out.println(f);
		UIManager.put (key, f);
	    }
        }
    }
    /**Component initialization*/
    private void jbInit() throws Exception {
	this.setSize(new Dimension(400,300));
	jPanel1.setLayout(gridBagLayout1);
	universeLabel.setText("Universe:");
	universeBox.addItem("");
	universeBox.addItem(universeNumbers);
	universeBox.addItem(universeAlphabet);
	universeBox.addItem(universeAnimals);
	aLabel.setText("Set A:");
	universeBox.setEditable(true);
	universeBox.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    universeBox_actionPerformed(e);
		}
	    });
	aBox.setEditable(true);
	bLabel.setText("Set B:");
	guessLabel.setText("Guess:");
	answerLabel.setText("Answer:");
	answerBox.setEditable(false);
	operationLabel.setText("Operation:");
	//operationBox.setFont(new java.awt.Font("Arial Unicode MS", Font.PLAIN, 12));
	operationBox.addItem("A\u2229B");
	operationBox.addItem("A\u222aB");
	operationBox.addItem("A-B");
	operationBox.addItem("A\u0305\u222a\u0305B\u0305");
	operationBox.addItem("A\u0305\u2229\u0305B\u0305");
	operationBox.addItem("A\u0305-\u0305B\u0305");
	bBox.setEditable(true);
	checkButton.setText("Check Answer");
	checkButton.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    checkButton_actionPerformed(e);
		}
	    });
	showButton.setText("Show Answer");
	showButton.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    showButton_actionPerformed(e);
		}
	    });
	operationBox.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    operationBox_actionPerformed(e);
		}
	    });
	statusBar.setEditable(false);
	statusBar.setText("Type your answer into the \"Guess\" field");
	this.getContentPane().add(jPanel1, BorderLayout.CENTER);
	jPanel1.add(universeLabel,
		    new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER, 
					   GridBagConstraints.BOTH, 
					   new Insets(2, 2, 2, 2),
					   2, 2));
	jPanel1.add(universeBox,
		    new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0,
					   GridBagConstraints.CENTER, 
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(aLabel, 
		    new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER, 
					   GridBagConstraints.BOTH, 
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(aBox, 
		    new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(bLabel, 
		    new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(bBox,
		    new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(operationLabel,
		    new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(operationPanel,
		    new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	operationPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
	operationPanel.add(operationBox);

	jPanel1.add(guessLabel, 
		    new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(guessBox, 
		    new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0,
					   GridBagConstraints.WEST,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(answerLabel, 
		    new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(answerBox, 
		    new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(checkButton, 
		    new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER, 
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(showButton,
		    new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0,
					   GridBagConstraints.EAST,
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
	jPanel1.add(statusBar,
		    new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0,
					   GridBagConstraints.CENTER, 
					   GridBagConstraints.BOTH,
					   new Insets(2, 2, 2, 2),
					   0, 0));
    }
    /**Get Applet information*/
    public String getAppletInfo() {
	return "Applet Information";
    }
    /**Get parameter info*/
    public String[][] getParameterInfo() {
	return null;
    }
    
    //static initializer for setting look & feel
    static {
	try {
	    //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
	}
	catch(Exception e) {
	}
    }
    
    TreeSet createSet(String setString){
	TreeSet set = new TreeSet();
	String token1, token2;
	
	StringTokenizer st1 = new StringTokenizer(setString, ", ");
	while (st1.hasMoreTokens()) {
	    token1 = st1.nextToken();
	    StringTokenizer st2 = new StringTokenizer(token1, ",");
	    while(st2.hasMoreTokens()){
		token2 = st2.nextToken();
		set.add(token2);
	    }
	}
	
	return set;
    }
    
    private String doOperationString(TreeSet dest, TreeSet source, int num){
	if(num <= 5){
	    TreeSet newSet = doOperation(dest, source, num);
	    return newSet.toString();
	}
	else if(num == 6){
	    return ""+dest.size();
	}
	else if(num == 7){
	    return ""+source.size();
	}
	return "Error";
    }
    
    /**
     * Performs a specified operation on a specified set
     * @param dest The recieving end of the operation ("A" in "A-B")
     * @param source The other end of the operation ("B" in "A-B")
     * @return The set resulting from performing the operation
     */
    private TreeSet doOperation(TreeSet dest, TreeSet source, int num){
	TreeSet newSet = (TreeSet)dest.clone();
	TreeSet universeSet = createSet((String)universeBox.getSelectedItem());
	
	if(num == 0){
	    newSet.retainAll(source);
	}
	else if(num == 1){
	    newSet.addAll(source);
	}
	else if(num == 2){
	    newSet.removeAll(source);
	}
	
	else if(num == 3){
	    newSet.retainAll(source);
	    universeSet.removeAll(newSet);
	    newSet = universeSet;
	}
	else if(num == 4){
	    newSet.addAll(source);
	    universeSet.removeAll(newSet);
	    newSet = universeSet;
	}
	else if(num == 5){
	    newSet.removeAll(source);
	    universeSet.removeAll(newSet);
	    newSet = universeSet;
	}
	
	
	return newSet;
    }
    
    
    private void operationBox_actionPerformed(ActionEvent e){
	//System.out.println("Here goes...");
	statusBar.setBackground(new Color(207, 207, 207));
	statusBar.setText("Type your answer into the \"Guess\" field");
    }
    

    private void showButton_actionPerformed(ActionEvent e) {
	String aString = (String)aBox.getSelectedItem();
	String bString = (String)bBox.getSelectedItem();
	TreeSet setA = new TreeSet();
	TreeSet setB = new TreeSet();
	
	//System.out.println(aString);
	//System.out.println(bString);
	
	setA = createSet(aString);
	setB = createSet(bString);
	
	//setA = doOperation(setA, setB, operationBox.getSelectedIndex());
	//aString = (setA.toString());
	
	aString = doOperationString(setA, setB, operationBox.getSelectedIndex());
	aString = aString.replace('[', ' ');
	aString = aString.replace(']', ' ');
	//System.out.println(aString);
	if(aString.equals("  "))
	    answerBox.setText("<Empty Set>");
	else
	    answerBox.setText(aString);
    }
    
    private void checkButton_actionPerformed(ActionEvent e) {
	TreeSet setA = createSet((String)aBox.getSelectedItem());
	TreeSet setB = createSet((String)bBox.getSelectedItem());
	TreeSet setAnswer;
	TreeSet setGuess = createSet(guessBox.getText());
	String[] stringA = (String[])setA.toArray(new String[0]);
	String[] stringB = (String[])setB.toArray(new String[0]);
	String[] stringGuess = (String[])setGuess.toArray(new String[0]);
	String[] stringAnswer;
	
	
	setAnswer = doOperation(setA, setB, operationBox.getSelectedIndex());
	stringAnswer = (String[])setAnswer.toArray(new String[0]);
	
	if(stringAnswer.length != stringGuess.length){
	    //System.out.println("Different Lengths\n");
	    statusBar.setBackground(Color.red);
	    statusBar.setText("Incorrect, please try again");
	    return;
	}
	
	setAnswer.removeAll(setGuess);
	if(((String[])setAnswer.toArray(new String[0])).length == 0){
	    //System.out.println("Same\n");
	    statusBar.setBackground(Color.green);
	    statusBar.setText("Correct!");
	    return;
	}
	//System.out.println("Nothing caught me - must be wrong\n");
	statusBar.setBackground(Color.red);
	statusBar.setText("Incorrect, please try again");
    }
    
    private void guessBox_mouseClicked(MouseEvent e) {
	statusBar.setBackground(new Color(207, 207, 207));
	statusBar.setText("Type your answer into the \"Guess\" field");
    }
    
    private void universeBox_actionPerformed(ActionEvent e) {
	//System.out.println("Here goes...");
	aBox.removeAllItems();
	bBox.removeAllItems();
	switch (universeBox.getSelectedIndex()){
	case 1:
	    for(int i=0;i<aBoxNumbers.length;i++){
		aBox.addItem(aBoxNumbers[i]);
	    }
	    for(int i=0;i<bBoxNumbers.length;i++){
		bBox.addItem(bBoxNumbers[i]);
	    }
	    break;
	case 2:
	    for(int i=0;i<aBoxAlphabet.length;i++){
		aBox.addItem(aBoxAlphabet[i]);
	    }
	    for(int i=0;i<bBoxAlphabet.length;i++){
		bBox.addItem(bBoxAlphabet[i]);
	    }
	    break;
	case 3:
	    for(int i=0;i<aBoxAnimals.length;i++){
		aBox.addItem(aBoxAnimals[i]);
	    }
	    for(int i=0;i<bBoxAnimals.length;i++){
		bBox.addItem(bBoxAnimals[i]);
	    }
	    break;
	}
    }
}
